/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus;

public class BonusConst {
	
	/* bZ[W֘A */
	public static final String MSG_TRAINED         = "IU0001";
	public static final String MSG_FELLOW          = "IU0001";
	public static final String MSG_SUPPORT         = "IU0003";
	public static final String MSG_FINISH          = "IU0011";
	public static final String MSG_BACK            = "IU0012";
	public static final String MSG_NEXT            = "IU0013";
	public static final String MSG_APPLY           = "IU0014";
	public static final String MSG_REGIST_APPLY    = "IU0015";
	public static final String MSG_CSV_UPLOAD      = "IP2002";
	public static final String MSG_NO_UPLOAD_HUMAN = "IC0006";
	public static final String MSG_DOING           = "IC0014";
	
	public static final String MSG_INVALID_CSV_HEAD  = "WC0012";
	public static final String MSG_INVALID_CSV_COUNT = "WC0013";
	public static final String MSG_INVALID_FILE_TYPE = "WC0014";
	public static final String MSG_NO_UPLOAD_KEY     = "WC0015";
	public static final String MSG_INVALID_HEAD_TYPE = "WC0016";
	public static final String MSG_INVALID_DATA_TYPE = "WC0017";
	public static final String MSG_NO_CSV_DATA       = "WC0018";
	public static final String MSG_INVALID_HEAD      = "WC0019";
	public static final String MSG_UP_INVALID_TYPE   = "WC0020";
	public static final String MSG_UP_TOO_LONG       = "WC0021";
	public static final String MSG_UP_NOT_A_NUMBER   = "WC0022";
	public static final String MSG_NOT_PAY_CALCULATE = "WC0024";
	public static final String MSG_NOT_UP_EMP_TYPE   = "WC0027";
	public static final String MSG_NO_DETAIL_DATA    = "WC0028";
	public static final String MSG_UP_RETIRED        = "WC0029";
	public static final String MSG_UP_NO_SET_KEY     = "WC0031";
	
	public static final String MSG_BEFORE_CURRENT    = "WU1101";
	public static final String MSG_TERM_DUPLICATE    = "WU1102";
	public static final String MSG_SUPPORT_END       = "WU1103";
	public static final String MSG_NOT_EDITABLE      = "WU1104";
	public static final String MSG_IS_USED           = "WU1105";
	public static final String MSG_DISABLE_TID       = "WU1106";
	public static final String MSG_NOT_FIXED         = "WU1111";
	
	public static final String MSG_BACK_BEFORE_CALC  = "WU1112";
	public static final String MSG_NO_PAYMENT        = "WU1113";
	public static final String MSG_APPLY_BEFORE_CALC = "WU1114";
	public static final String MSG_NO_BATCH_APPLY    = "WU1115";
	public static final String MSG_NO_HUMAN_DATA     = "WU1116";
	public static final String MSG_EXCLUSIVE         = "WU1117";
	public static final String MSG_NOT_CURRENT       = "WU1118";
	public static final String MSG_FIX_FAILED        = "WU1119";
	public static final String MSG_NO_BONUS          = "WU1120";
	public static final String MSG_NO_RESIDENCE      = "WU1135";
	public static final String MSG_BEFORE_ENTRANCE   = "WU1122";
	public static final String MSG_CAN_NOT_DELETE    = "WU1123";
	public static final String MSG_NO_ADJUST_TYPE    = "WU1124";
	public static final String MSG_DIF_ADJUST_YEAR   = "WU1125";
	public static final String MSG_NO_OUTPUT_DATA    = "WU1126";
	public static final String MSG_NO_ADJ_PAY_DATA   = "WU1127";
	public static final String MSG_NO_TARGET         = "WU1128";
	public static final String MSG_NO_TARGET_DATA    = "WU1129";
	public static final String MSG_ADJ_NO_TARGET_DATA = "WU1132";
	public static final String MSG_EXC_REG_BONUS      = "WU1133";
	
	public static final String MSG_NO_ADJUST_REPORT   = "WU1134";
	public static final String MSG_NO_BONUS_DETAIL    = "WU1136";
	
	public static final String MSG_NO_AUTHORITY      = "WU1140";
	public static final String MSG_NO_ADD_HISTORY    = "WU1141";
	public static final String MSG_NO_EXPECTED_BASIS = "WU1142";
	public static final String MSG_NO_CODE_BASIS     = "WU1143";
	public static final String MSG_THING_NOT_EXITS   = "WU1144";
	
	public static final String MSG_NO_PAYMENT_DETAIL = "WU1130";
	public static final String MSG_NO_ATTENDANCE     = "WU2101";
	public static final String MSG_DATA_DELETED      = "WU2102";
	public static final String MSG_NO_HISTORY        = "WU2103";
	public static final String MSG_RETIRED           = "WU2104";
	public static final String MSG_AFTER_CURRENT     = "WU2105";
	public static final String MSG_NO_AVAILABLE_STA  = "WU2107";
	
	public static final String MSG_BONUS_CALC_NG		= "WP1221";  /* ʌvZĂ܂B */
	public static final String MSG_BONUS_FIX_NG		= "WP1222";  /* ʊm菈Ă܂B */
	public static final String MSG_BONUS_TATAL_OVER	= "WP1223";  /* TzxzI[o[Ă܂B */
	
	public static final int EX_BEFORE_CURRENT    = 1101;
	public static final int EX_TERM_DUPLICATE    = 1102;
	public static final int EX_SUPPORT_END       = 1103;
	public static final int EX_NOT_EDITABLE      = 1104;
	public static final int EX_IS_USED           = 1105;
	public static final int EX_DISABLE_TID       = 1106;
	public static final int EX_NOT_FIXED         = 1111;
	public static final int EX_BACK_BEFORE_CALC  = 1112;
	public static final int EX_APPLY_BEFORE_CALC = 1114;
	public static final int EX_NO_HUMAN_DATA     = 1116;
	public static final int EX_NOT_CURRENT       = 1118;
	public static final int EX_BEFORE_ENTRANCE   = 1122;
	public static final int EX_CAN_NOT_DELETE    = 1123;
	public static final int EX_NO_ADJUST_TYPE    = 1124;
	public static final int EX_DIF_ADJUST_YEAR   = 1125;
	public static final int EX_NO_PAYMENT_DETAIL = 1130;
	public static final int EX_NO_AUTHORITY      = 1140;
	public static final int EX_NO_ATTENDANCE     = 2101;
	public static final int EX_DATA_DELETED      = 2102;
	public static final int EX_NO_HISTORY        = 2103;
	public static final int EX_RETIRED           = 2104;
	public static final int EX_AFTER_CURRENT     = 2105;
	public static final int EX_NO_BASIS          = 2106;
	public static final int EX_NO_AVAILABLE_STA  = 2107;
	public static final int EX_PRINT_FAILED      = 6001;

	/* tO֘A */
	public static final int CHECKBOX_OFF           = 0;
	public static final int CHECKBOX_ON            = 1;
	public static final int DEFAULT_FLAG_OFF       = 0;
	public static final int DEFAULT_FLAG_ON        = 1;
	public static final int FIELD_FLAG_OFF         = 0;
	public static final int FIELD_FLAG_ON          = 1;
	public static final int TIME_FLAG_OFF          = 0;
	public static final int TIME_FLAG_ALL          = 1;
	public static final int TIME_FLAG_OFFICE       = 2;
	public static final int TRAIN_FLAG_OFF         = 0;
	public static final int TRAIN_FLAG_TRAINED     = 1;
	public static final int TRAIN_FLAG_TRAINING    = 2;
	public static final int MISSING_INPUT_FLAG_OFF = 0;
	public static final int MISSING_INPUT_FLAG_ON  = 1;
	public static final int WORK_FLAG_OFF          = 0;
	public static final int WORK_FLAG_ON           = 1;
	public static final int EFFORT_FLAG_OFF        = 0;
	public static final int EFFORT_FLAG_ON         = 1;
	public static final int RETIREMENT_FLAG_OFF    = 0;
	public static final int RETIREMENT_FLAG_ON     = 1;

	/* VOۑ */
	public static final String VO_ATTENDANCE_LIST  = "ATTENDANCE_LIST_VO" ;
	public static final String VO_ATTENDANCE_CARD  = "ATTENDANCE_CARD_VO" ;
	public static final String VO_EMPLOYEE_SELECT  = "EMPLOYEE_SELECT_VO" ;
	public static final String VO_SUPERIOR_LIST    = "SUPERIOR_LIST_VO"   ;
	public static final String VO_SUPERIOR_CARD    = "SUPERIOR_CARD_VO"   ;
	public static final String VO_SUPPORT_LIST     = "SUPPORT_LIST_VO"    ;
	public static final String VO_SUPPORT_CARD     = "SUPPORT_CARD_VO"    ;
	public static final String VO_ATTENDANCE_FIX   = "ATTENDANCE_FIX_VO"  ;
	public static final String VO_CONFIRM_ATT_LIST = "CONFIRM_ATT_LIST_VO";
	public static final String VO_ADJUSTMENT_CALC  = "ADJUSTMENT_CALC_VO" ;
	public static final String VO_ADJUSTMENT_CARD  = "ADJUSTMENT_CARD_VO" ;
	public static final String VO_ADJUSTMENT_LIST  = "ADJUSTMENT_LIST_VO" ;
	public static final String VO_HUMAN_LIST       = "HUMAN_LIST_VO"      ;
	public static final String VO_HISTORY_LIST     = "HISTORY_LIST_VO"    ;
	public static final String VO_HUMAN_CARD       = "HUMAN_CARD_VO"      ;
	public static final String VO_HUMAN_BASIS      = "HUMAN_BASIS_VO"     ;
	public static final String VO_HUMAN_CALC       = "HUMAN_CALC_VO"      ;
	public static final String VO_HUMAN_PERSONNEL  = "HUMAN_PERSONNEL_VO" ;
	
	/* DTOۑ */
	public static final String ATT_UM_BASIS_DTO = "umBasisDto";
	public static final String ATT_UH_BASIS_DTO = "uhBasisDto";
	
	/* r֘A */
	public static final String ATT_EXCLUSIVE   = "exclusive";
	public static final int    EXC_HUMAN_BASIS = 1;
	public static final int    EXC_HUMAN_CA_PE = 2;
	
	/* j[ID */
	public static final String MENU_ID_INPUT   = "INPUT"  ;
	public static final String MENU_ID_MANAGE  = "MANAGE" ;
	public static final String MENU_ID_PAYROLL = "PAYROLL";
	public static final String MENU_ID_HUMAN   = "HUMAN"  ;
	public static final String MENU_ID_SYSTEM  = "SYSTEM" ;
	public static final String MENU_ID_SYSTEM2 = "SYSTEM2";
	
	// {^eύX
	public static final String BTN_BONUS   = "BONUS"  ;
	public static final String BTN_PAYMENT = "PAYMENT";
	public static final String BTN_ADJUST  = "ADJUST" ;
	public static final String BTN_COMMUTE = "COMMUTE" ;
	
	/* tH[}bg */
	public static final String FORMAT_TIME        = "HH:mm";
	public static final String FORMAT_DATE        = "yyyy/MM/dd";
	public static final String FORMAT_DATE_SHORT  = "yyyy/MM";
	public static final String FORMAT_DATE_JP     = "yyyyNMMdd";
	public static final String FORMAT_YEAR_MONTH  = "yyyyN M";
	public static final String SEPARATOR_DATE     = "/";
	public static final String SUPPRESS_DATE      = "0";
	public static final String FORMAT_UNIT_AMOUNT = "#######0.##";
	
	/* R[h敪 */
	public static final String TID_AUTHORITY     = "AUTHORITY";	// R[h
	public static final String TID_BUSINESS_TYPE = "BUSINESS" ;	// Ƌ敪
	public static final String TID_CALENDAR_TYPE = "CALENDAR" ;	// J_[敪
	public static final String TID_EFFORT_TYPE   = "EFFORT"   ;	// ʗ敪
	public static final String TID_FIELD         = "FIELD"    ;	// tB[htO
	public static final String TID_GENDER        = "GENDER"   ;	// 
	public static final String TID_HOLIDAY_TYPE  = "HOLIDAY"  ;	// Lxɋ敪
	public static final String TID_JAPANESE      = "JAPANESE" ;	// N
	public static final String TID_OVERTIME_TYPE = "OVERTIME" ;	// cƋ敪
	public static final String TID_PAYMENT_TYPE  = "PAYMENT"  ;	// x敪
	public static final String TID_RELATION      = "RELATION" ;	// 
	public static final String TID_TIME          = "TIME"     ;	// ԏtO
	public static final String TID_TOTAL_TYPE    = "TOTAL"    ;	// Wv敪
	public static final String TID_TRAIN         = "TRAIN"    ;	// /CtO
	public static final String TID_ACCOUNT_TYPE  = "ACCOUNT"  ;	// a敪
	public static final String TID_PAYMENT_MEANS = "MEANS"    ;	// x@
	public static final String TID_PAY_INTERVAL  = "INTERVAL" ;	// xԊu
	public static final String TID_LUMP_TYPE     = "LUMP"     ;	// ꊇ敪
	public static final String TID_UNIT_TYPE     = "UNIT"     ;	// P敪
	public static final String TID_DETAIL_CODE   = "DETAIL"   ;	// ׃R[h
	public static final String TID_DISPLAY_TYPE  = "DISPLAY"  ;	// ו\@敪
	public static final String TID_EXPRESS       = "EXPRESS"  ;	// vZݒ薾׃R[h
	
	public static final String TNM_AUTHORITY     = "R[h"          ;	// R[h
	public static final String TNM_BUSINESS_TYPE = "Ƌ敪"            ;	// Ƌ敪
	public static final String TNM_CALENDAR_TYPE = "J_[敪"      ;	// J_[敪
	public static final String TNM_EFFORT_TYPE   = "ʗ敪"          ;	// ʗ敪
	public static final String TNM_FIELD         = "tB[htO";	// tB[htO
	public static final String TNM_GENDER        = ""                ;	// ʋ敪
	public static final String TNM_HOLIDAY_TYPE  = "Lxɋ敪"        ;	// Lxɋ敪
	public static final String TNM_OVERTIME_TYPE = "cƋ敪"            ;	// cƋ敪
	public static final String TNM_PAYMENT_TYPE  = "x敪"            ;	// x敪
	public static final String TNM_RELATION      = ""                ;	// 
	public static final String TNM_TIME          = "ԏtO"      ;	// ԏtO
	public static final String TNM_TOTAL_TYPE    = "Wv敪"            ;	// Wv敪
	public static final String TNM_TRAIN         = "挤CtO";	// /CtO
	public static final String TNM_ACCOUNT_TYPE  = "a敪"            ;	// a敪
	public static final String TNM_PAYMENT_MEANS = "x@"            ;	// x@
	public static final String TNM_PAY_INTERVAL  = "xԊu"            ;	// xԊu
	public static final String TNM_LUMP_TYPE     = "ꊇ敪"            ;	// ꊇ敪
	public static final String TNM_UNIT_TYPE     = "P敪"            ;	// P敪
	public static final String TNM_DETAIL_CODE   = "׃R[h"          ;	// ׃R[h
	public static final String TNM_DISPLAY_TYPE  = "ו\@敪"    ;	// ו\@敪
	public static final String TNM_EXPRESS       = "vZݒ薾"      ;	// vZݒ薾
	public static final String TNM_JAPANESE      = "N"                ;	// N

	/* ǉR[h敪 */
	public static final String EXID_LICENSE    = "LICENSE" ;	// ƋR[h
	public static final String EXID_EVALUATE   = "EVALUATE";	// ]R[h
	public static final String EXID_COURSE     = "COURSE"  ;	// C敪
	public static final String EXID_ACCIDENT   = "ACCIDENT";	// ̃R[h
	public static final String EXID_SUSPENSION = "SUSPENSE";	// xƃR[h
	public static final String EXID_ACC_CAUSE  = "ACCCAUSE";	// R[h
	public static final String EXID_BONUS_DED  = "BONUSDED";	// ܗ^TR[h
	
	public static final String EXNM_LICENSE    = "ƋR[h";	// ƋR[h
	public static final String EXNM_EVALUATE   = "]R[h";	// ]R[h
	public static final String EXNM_COURSE     = "C敪"  ;	// C敪
	public static final String EXNM_ACCIDENT   = "̃R[h";	// ̃R[h
	public static final String EXNM_SUSPENSION = "xƃR[h";	// xƃR[h
	public static final String EXNM_ACC_CAUSE  = "R[h";	// R[h
	public static final String EXNM_BONUS_DED  = "ܗ^TR[h";	// ܗ^TR[h
	
	/**
	 * ׃R[h(xz)B
	 */
	public static final String DTL_SUM_ALLOWANCE = "BS001";
	
	/**
	 * ׃R[h(Tz)B
	 */
	public static final String DTL_SUM_DEDUCTION = "BS002";
	
	/**
	 * ׃R[h(xz)B
	 */
	public static final String DTL_SUM_TOTAL = "BS003";
	
	/**
	 * ׃R[h(ېŎxz)B
	 */
	public static final String DTL_SUM_TAXATION = "BS004";
	
	/**
	 * ׃R[h(Љیv)B
	 */
	public static final String DTL_SUM_SOC_INS = "BS005";
	
	/**
	 * ׃R[h(s1xz)B
	 */
	public static final String DTL_SUM_BANK1 = "BS011";
	
	/**
	 * ׃R[h(s2xz)B
	 */
	public static final String DTL_SUM_BANK2 = "BS012";
	
	/**
	 * ׃R[h(xz)B
	 */
	public static final String DTL_SUM_CASH = "BS013";

	
	
	
	/* w薳(US_WORK_TYPEAUS_TIME_TYPEp */
	public static final String SETTING_NONE = "**";
	/* 򒥎AY */
	public static final String ADJ_APPLICABLE = "*";

	/* vZ(UT_CURRENT) */
	public static final String CURRENT_CALC   = "***";
	public static final String CURRENT_ADJUST = "+++";
	/* ܗ^׎擾p */
	public static final String BONUS_DETAIL = "S";
	
	/* ݒ敪 */
	public static final String CONF_ID_INITIAL_CMD  = "INITIAL" ;	// R}h
	public static final String CONF_ID_CLOSE        = "CLOSE"   ;	// 
	public static final String CONF_ID_MANAGER      = "MANAGER" ;	// ƏǗҌ
	public static final String CONF_ID_REFERER      = "REFERER" ;	// lQƒSҌ
	public static final String CONF_ID_PUNCHER      = "PUNCHER" ;	// ǉSҌ
	public static final String CONF_ID_PAYROLL      = "PAYROLL" ;	// l^
	public static final String CONF_ID_WORK_HOUR    = "WORKHOUR";	// 1J
	public static final String CONF_ID_LATE_NIGHT   = "NIGHT"   ;	// [鎞
	public static final String CONF_ID_MISSING_LMT  = "MISSING" ;	// FΌzΏےx
	public static final String CONF_ID_HOLIDAY_INV  = "HOLIDAY" ;	// LxɔԊu
	public static final String CONF_ID_WORK_RATIO   = "RATIO"   ;	// LxɔoΗ
	public static final String CONF_ID_JP_IMP_CAL   = "JC_%"    ;	// aݒ
	public static final String CONF_ID_RATIO_OT     = "RATIO_OT";	// cƎ蓖
	public static final String CONF_ID_RATIO_LN     = "RATIO_LN";	// [蓖
	public static final String CONF_ID_RATIO_WH     = "RATIO_WH";	// xo蓖
	public static final String CONF_ID_FAMILIY_AW   = "FAMIL_AW";	// }{蓖P
	public static final String CONF_ID_FAMILIY_LM   = "FAMIL_LM";	// }{蓖
	public static final String CONF_ID_ADJUST_APPL  = "ADJUST"  ;	// NKp(Kp@AN)
	public static final String CONF_ID_COMMUTE_UNIT = "TRAUNT"  ;	// ʋΎ蓖(ʗp)P
	public static final String CONF_ID_DELETE_EMPL  = "DEL_EMPL";	// l폜\(Г)

	public static final String CONF_ID_PAY_DAY     = "PAY_DAY" ;	// x
	public static final String CONF_ID_PAY_ITBL    = "PAY_ITBL";	// xԊu
	public static final String CONF_ID_ADJ_TRGT    = "ADJ_TRGT";	// NΏۃf[^ID

	public static final String CONF_ID_FB_CO_ADDRESS   = "FBADRS";	// FBf[^pЏZ
	public static final String CONF_ID_FB_COMPANY_NAME = "FBCONM";	// FBf[^pЖ
	
	public static final String CONF_CD_ADJUST_PAY  = "0"       ;	// N^Kp(Value͓Kp)
	public static final String CONF_CD_ADJ_TRGT  = "0"       ;	// NΏۃf[^R[h
	public static final String CONF_CD_FB_CO_ADDRESS   = "0"       ;	// FBf[^pЏZ
	public static final String CONF_CD_FB_COMPANY_NAME = "0"       ;	// FBf[^pЖ
	
	
	/**
	 *  sf[^̃t@C̃pX(sAxX\pjavascript)B<br>
	 */
	public static final String JS_FINANCE  = "/pub/common/js/finance.js";
	
	/**
	 * javascriptpB<br>
	 */		
	public static final String JS_FINANCE_NAME = "fne";

	
	/* ev[gt@C */
	public static final String TEMPLATE_ATTENDANCE_BOOK   = "/template/attendanceBook.xls";
	public static final String TEMPLATE_ATTENDANCE_TABLE  = "/template/attendanceTable.xls";
	

	/* o̓t@C */
	public static final String FILE_ATTENDANCE_BOOK    = "AttendanceBook.xls";
	public static final String FILE_ATTENDANCE_TABLE   = "AttendanceTable.xls";
	public static final String FILE_ATTENDANCE_REPORT  = "AttendanceReport.txt";
	public static final String FILE_ATTENDANCE_DATA    = "AttendanceData.txt";
	public static final String FILE_PAYMENT_DATA       = "PaymentData.txt";
	public static final String FILE_PAYMENT_DETAIL     = "PaymentDetail.pdf";
	public static final String FILE_BONUS_DETAIL       = "BonusDetail.pdf";
	public static final String FILE_FB_PAYMENT_DATA    = "FB_PaymentData.txt";
	public static final String FILE_FB_BONUS_DATA      = "FB_BonusData.txt";
	public static final String FILE_FB_RESIDE_DATA     = "FB_ResideData.txt";
	public static final String FILE_HUMAN_DATA         = "HumanData.txt";
	public static final String FILE_BONUS_DATA         = "BonusDataOutput.txt";
	public static final String FILE_LICENSE_DATA       = "LicenseDataOutput.txt";
	public static final String FILE_ACCINDENT_DATA     = "AccidentDataOutput.txt";
	public static final String FILE_CLOSED_DATA        = "ClosedDataOutput.txt";
	public static final String FILE_COURSE_DATA        = "CourseDataOutput.txt";
	public static final String FILE_EVALUATE_DATA      = "EvaluateDataOutput.txt";
	public static final String FILE_HUMAN_HISTORY_DATA = "HumanHistoryDataOutput.txt";
	public static final String FILE_NAME_SEPARATOR     = "-";
	public static final String STR_CSV_SEPARATOR       = ",";
	public static final String STR_CSV_NEW_LINE        = "\r\n";
	public static final String FILE_ADJUST_DATA        = "AdjustData.txt";
	public static final String FILE_WITHHOLDING_VOTE   = "WithholdingVote.pdf";
	public static final String FILE_WITHHOLDING_LIST   = "WithholdingList.pdf";
	public static final String FILE_PAYMENT_LEDGER     = "PaymentLedger.pdf";
	public static final String FILE_LEAVE_JOB_LIST     = "LeaveJobList.pdf";
	
	
	/* ږ */
	public static final String NAM_HEADER_SELECT      = "wb_[ꗗ";
	public static final String NAM_USER_ID            = "[U[ID";
	public static final String NAM_USER_NAME          = "[U[";
	public static final String NAM_PASSWORD           = "pX[h";
	public static final String NAM_AUTHORITY          = "p";
	public static final String NAM_DATA_LEVEL         = "f[^x";
	public static final String NAM_K_CODE             = "ЈR[h";
	public static final String NAM_K_NAME             = "Ј";
	public static final String NAM_K_KANA             = "ض";
	public static final String NAM_STATION            = "";
	public static final String NAM_BELONGED           = "Ə";
	public static final String NAM_POSITION           = "E";
	public static final String NAM_DATE               = "t";
	public static final String NAM_YEAR               = "N";
	public static final String NAM_MONTH              = "";
	public static final String NAM_DAY                = "";
	public static final String NAM_HOUR               = "";
	public static final String NAM_MINUTE             = "";
	public static final String NAM_BIRTH              = "";
	public static final String NAM_DAY_OF_WEEK        = "j";
	public static final String NAM_ATTENDANCE_TYPE    = "Α";
	public static final String NAM_WORK_TYPE          = "`";
	public static final String NAM_TIME_TYPE          = "E";
	public static final String NAM_START_TIME         = "o";
	public static final String NAM_DEPART_TIME        = "o";
	public static final String NAM_RETURN_TIME        = "A";
	public static final String NAM_QUIT_TIME          = "ގ";
	public static final String NAM_INTERVAL_TIME      = "xe";
	public static final String NAM_ARRIVE_LATE        = "x";
	public static final String NAM_LEAVE_EARLY        = "";
	public static final String NAM_PAYMENT_HOURS_ABB  = "Ύ";
	public static final String NAM_ROUTE_NO           = "[gNo";
	public static final String NAM_ROUTE_1            = "Rt1";
	public static final String NAM_TRAINED            = "";
	public static final String NAM_TRAINING           = "C";
	public static final String NAM_FELLOW_TRAINER     = "";
	public static final String NAM_FLESH_FELLOW       = "Vl";
	public static final String NAM_ROUTE_TRIP         = "Trip";
	public static final String NAM_ROUTE_COUNT        = "";
	public static final String NAM_ROUTE_DISTANCE     = "";
	public static final String NAM_ACCIDENT           = "";
	public static final String NAM_SUSPENSION         = "ƒ";
	public static final String NAM_REMARKS            = "l";
	public static final String NAM_PRESCRIBED_DAYS    = "vo";
	public static final String NAM_PRESENCE           = "o";
	public static final String NAM_WORK_ON_HOLIDAY    = "xo";
	public static final String NAM_PARTICULAR_HOLIDAY = "x";
	public static final String NAM_ABB_PAID_HOLIDAY   = "Lx";
	public static final String NAM_ABSENCE            = "";
	public static final String NAM_PAID_HOLIDAY_REST  = "Lxc";
	public static final String NAM_MISSING_INPUT      = "Wv";
	public static final String NAM_DELETE_FLAG        = "L/";
	public static final String NAM_OLD_PASSWORD       = "pX[h";
	public static final String NAM_NEW_PASSWORD       = "VpX[h";
	public static final String NAM_CONFIRM_PASS       = "mF";
	public static final String NAM_SUPERIOR_CODE      = "T|[^[";
	public static final String NAM_SUPERIOR_NAME      = "T|[^[";
	public static final String NAM_SUPPORTED          = "x";
	public static final String NAM_START_DATE         = "xJn";
	public static final String NAM_END_DATE           = "xI";
	public static final String NAM_CURRENT            = "Wv";
	public static final String NAM_EFFORT             = "";
	public static final String NAM_CALC_CURRENT       = "vZ";
	public static final String NAM_OUTPUT             = "o͌";
	public static final String NAM_ATTENDANCE_FIX     = "m";
	public static final String NAM_CONTAIN_MISSING    = "͊";
	public static final String NAM_ATTENDANCE_DATE    = "Αӓ";
	public static final String NAM_INCOMPATIBILITY    = "se";
	public static final String NAM_OTHER_CODE         = "R[h";
	public static final String NAM_OTHER_NAME         = "薼";
	public static final String NAM_EMPLOYMENT         = "ٗp";
	public static final String NAM_WORKING_HOURS      = "ғ";
	public static final String NAM_PAYMENT_HOURS      = "";
	public static final String NAM_OVERTIME           = "c";
	public static final String NAM_EFFORT_OVER        = "ʁEc";
	public static final String NAM_LATE_NIGHT         = "[";
	public static final String NAM_FAMILY_ALLOWANCE   = "}{蓖";
	public static final String NAM_COMMUTATION        = "ʋΎ蓖";
	public static final String NAM_TRAFFIC_COM_UNIT   = "ʋΎ蓖(ʗp)P";
	public static final String NAM_OVERTIME_ALLOWANCE = "E[Ex";
	public static final String NAM_CUT_FROM_BASIC     = "z";
	public static final String NAM_CUT_FOR_MISSING    = "FΌz";
	public static final String NAM_CUT_FOR_SHORT      = "Ezo";
	public static final String NAM_EMPLOYEE_INSURANCE = "ٗpی";
	public static final String NAM_ALLOWANCE_TOTAL    = "xz";
	public static final String NAM_DEDUCTION_TOTAL    = "Tz";
	public static final String NAM_PAYMENT_TOTAL      = "xz";
	public static final String NAM_BANK1_PAY_AMOUNT   = "s1Uz";
	public static final String NAM_BANK2_PAY_AMOUNT   = "s2Uz";
	public static final String NAM_CASH_PAY_AMOUNT    = "xz";
	public static final String NAM_TAX_ALLOWANCE      = "ېőΏ";
	public static final String NAM_PRESCRIBED_DAYS_FL = "J";
	public static final String NAM_PRESCRIBED_HOURS   = "J";

	public static final String NAM_UP_LICENSE         = "Ƌ";
	public static final String NAM_UP_EVALUATE        = "]";
	public static final String NAM_UP_COURSE          = "ʐMu";
	public static final String NAM_UP_ACCIDENT        = "ԗ̗";
	public static final String NAM_UP_CLOSED          = "xƗ";
	
	public static final String NAM_OUT_LICENSE         = "Ƌo";
	public static final String NAM_OUT_EVALUATE        = "]o";
	public static final String NAM_OUT_COURSE          = "ʐMuo";
	public static final String NAM_OUT_ACCIDENT        = "ԗ̗o";
	public static final String NAM_OUT_HUMAN           = "l{o";
	public static final String NAM_OUT_CLOSED          = "xƗo";
	
	public static final String NAM_LICENSE_TYPE        = "Ƌ";
	public static final String NAM_LICENSE_GET_DATE    = "Ƌ擾";
	public static final String NAM_LICENSE_REMARKS     = "Ƌl";

	public static final String NAM_EVALUATE            = "]";
	public static final String NAM_EVALUATE_REMARKS    = "]l";
	public static final String NAM_EVALUATE_DATE       = "]N";

	public static final String NAM_COURSE_CONTENTS     = "ʐMe";
	public static final String NAM_COURSE_DATE         = "ʐMu";
	public static final String NAM_COMPLETION_TYPE     = "C敪";
	public static final String NAM_COURSE_REMARKS      = "ʐMl";

	public static final String NAM_ACCIDENT_DATE        = "̓";
	public static final String NAM_ACCIDENT_CONTENTS    = "ԗ̓e";
	public static final String NAM_ACCIDENT_CAUSE       = "";
	public static final String NAM_BONUS_DEDUCTION      = "ܗ^T";
	public static final String NAM_OUR_REMARKS          = "Дl";
	public static final String NAM_OTHER_REMARKS        = "l";
	public static final String NAM_ACCIDENT_REMARKS1    = "ԗ̔l1";
	public static final String NAM_ACCIDENT_REMARKS2    = "ԗ̔l2";

	public static final String NAM_CLOSED_START_DATE   = "Jn";
	public static final String NAM_CLOSED_END_DATE     = "I";
	public static final String NAM_CLOSED_CONTENTS     = "xƓe";
	public static final String NAM_CLOSED_REMARKS      = "xƔl";

	public static final String NAM_OUT_START_MONTH     = "o͊JnN";
	public static final String NAM_OUT_END_MONTH       = "o͏IN";
	
	public static final String NAM_DETAIL_SETTING      = "אݒ";
	public static final String NAM_DETAIL_CODE         = "׋敪";
	
	public static final String NAM_PAYMENT_TARGET     = "^";
	public static final String NAM_BONUS_TARGET       = "ܗ^";
	public static final String NAM_BONUS_DATE         = "ܗ^x";


	public static final String NAM_UPLOAD_DATE         = "Abv[hN";
	
	public static final String NAM_DATE_ALLOWANCE     = "t蓖";
	public static final String NAM_ALLOWANCE_NAME     = "蓖";
	public static final String NAM_ALLOWANCE_DATE     = "蓖Ώۓ";
	public static final String NAM_ALLOWANCE_AMOUNT   = "蓖";
	public static final String NAM_HOLIDAY_MONTH      = "";
	public static final String NAM_HOLI_START_MONTH   = "LxɋNZ";
	public static final String NAM_THIS_YEAR_REST     = "{Nc";
	public static final String NAM_LAST_YEAR_REST     = "ONc";
	public static final String NAM_CONFIRM_MONTH      = "mF";
	public static final String NAM_EXPECTED_DATE      = "Kp\";
	public static final String NAM_APPLIED_DATE       = "Kp";
	public static final String NAM_GRADE              = "";
	public static final String NAM_NOTCH              = "";
	public static final String NAM_BASIC_SALARY       = "{";
	public static final String NAM_EMPLOYMENT_TYPE    = "ٗp敪";
	public static final String NAM_BONUS_SALARY       = "Wܗ^";
	public static final String NAM_ABILITY_ALLOWANCE  = "E\蓖";
	public static final String NAM_ABILITY_ALLOWANCE2 = "E\蓖2";
	public static final String NAM_ENTRANCE_DATE      = "Г";
	public static final String NAM_RETIREMENT_DATE    = "ގГ";
	public static final String NAM_CHANGE_K_CODE      = "ύXЈR[h";
	public static final String NAM_CHANGING           = "ύXe";
	public static final String NAM_CHANGING_INFO      = "Kp";
	public static final String NAM_RETIREMENT_FLAG    = "ݐE/ސE";
	public static final String NAM_HUMAN_DATA_ITEM    = "l񍀖";
	public static final String NAM_HUMAN_DATA_SELECT  = "I";
	public static final String NAM_TARGET_MONTH       = "Ώ۔N";
	public static final String NAM_HU_MODE_INSERT     = "[VKo^[h]";
	public static final String NAM_HU_MODE_UPDATE     = "[XVo^[h]";
	public static final String NAM_HU_MODE_OVERWRITE  = "[Kp㏑[h]";
	public static final String NAM_BIRTH_DATE         = "N";
	public static final String NAM_FORMER_NAME        = "";
	public static final String NAM_POSTAL_CODE        = "X֔ԍ";
	public static final String NAM_ADDRESS            = "Z";
	public static final String NAM_FORMER_ADDRESS     = "Z";
	public static final String NAM_PHONE_NUMBER       = "dbԍ";
	public static final String NAM_CELLPHONE_NUMBER   = "gєԍ";
	public static final String NAM_EMERGENCY_NUMBER   = "ً}ԍ";
	public static final String NAM_APPOINTMENT_DATE   = "Јop";
	public static final String NAM_RETIRE_MONEY_DATE  = "ސENZ";
	public static final String NAM_EXTRA_DATE_1       = "\t1";
	public static final String NAM_EXTRA_ITEM_1       = "\1";
	public static final String NAM_FAMILY_NAME        = "O";
	public static final String NAM_INSURANCE_ITEMS    = "Љی";
	public static final String NAM_INSURANCE_HEALTH   = "Nی";
	public static final String NAM_INSURANCE_PENSION  = "Nی";
	public static final String NAM_INSURANCE_FUND     = "N";
	public static final String NAM_INSURANCE_EMPLOY   = "ٗpی";
	public static final String NAM_PENSION_TYPE       = "N";
	public static final String NAM_PARTTIME_TYPE      = "p[g敪";
	public static final String NAM_EMPLOYEE_TYPE      = "]ƈ敪";
	public static final String NAM_CALC_INS_TYPE      = "Љی敪";
	public static final String NAM_NURSING_INS_TYPE   = "ی敪";
	public static final String NAM_CALC_UNEMPLOY_TYPE = "ٗpی敪";
	public static final String NAM_BONUS_HEALTH_TYPE  = "ۏܗ^敪";
	public static final String NAM_BONUS_PENSION_TYPE = "Nܗ^敪";
	public static final String NAM_HEALTH_NO          = "Nیԍ";
	public static final String NAM_HEALTH_PAYMENT     = "ەWV";
	public static final String NAM_HEALTH_PREMIUM     = "Nی";
	public static final String NAM_NURSING_PREMIUM    = "ی";
	public static final String NAM_HEALTH_GET_DATE    = "ێ擾";
	public static final String NAM_HEALTH_LOST_TYPE   = "ۑr敪";
	public static final String NAM_HEALTH_LOST_DATE   = "ۑr";
	public static final String NAM_PENSION_NO         = "bNԍ";
	public static final String NAM_PENSION_PAYMENT    = "NWV";
	public static final String NAM_PENSION_PREMIUM    = "N";
	public static final String NAM_PENSION_GET_DATE   = "N擾";
	public static final String NAM_PENSION_LOST_TYPE  = "Nr敪";
	public static final String NAM_PENSION_LOST_DATE  = "Nr";
	public static final String NAM_FUND_NO            = "ԍ";
	public static final String NAM_FUND_PREMIUM       = "N";
	public static final String NAM_FUND_GET_DATE      = "擾";
	public static final String NAM_UNEMPLOY_NO        = "ٗpیԍ";
	public static final String NAM_UNEMPLOY_GET_DATE  = "ٕێ擾";
	public static final String NAM_UNEMPLOY_LOST_TYPE = "ٕۑr敪";
	public static final String NAM_UNEMPLOY_LOST_DATE = "ٕۑr";
	public static final String NAM_FAMILY_PENSION_NO  = "ƑNԍ";
	public static final String NAM_PAYMENT_MEANS      = "^U";
	public static final String NAM_PAYMENT_MEANS_1    = "^U1";
	public static final String NAM_PAYMENT_MEANS_2    = "^U2";
	public static final String NAM_PAYMENT_MEANS_3    = "ܗ^U1";
	public static final String NAM_PAYMENT_MEANS_4    = "ܗ^U2";
	public static final String NAM_CO_BANK_CODE       = "Ћs";
	public static final String NAM_PAID_BANK_CODE     = "Us";
	public static final String NAM_PAID_BRANCH_CODE   = "UxX";
	public static final String NAM_PAID_BANK_NAME     = "s";
	public static final String NAM_PAID_BRANCH_NAME   = "xX";
	public static final String NAM_ACCOUNT_NO         = "ԍ";
	public static final String NAM_HOLDER_NAME        = "`";
	public static final String NAM_HOLDER_KANA        = "ض";
	public static final String NAM_AMOUNT_TYPE        = "z敪";
	public static final String NAM_FIXED_AMOUNT       = "Œ";
	public static final String NAM_COMMUTATION_1      = "ʋΎ蓖1";
	public static final String NAM_COMMUTATION_2      = "ʋΎ蓖2";
	public static final String NAM_PAY_START_MONTH    = "xJn";
	public static final String NAM_COMMUTE_DISTANCE   = "Г";
	public static final String NAM_COMMUTE_AMOUNT     = "ʋΎ蓖x";
	public static final String NAM_COMMUTE_TAXED      = "ېŒʋΔ";
	public static final String NAM_PAYMENT_CITY_CODE  = "sR[h([t)";
	public static final String NAM_SUBMIT_CITY_CODE   = "sR[h(o)";
	public static final String NAM_JUNE_AMOUNT        = "6";
	public static final String NAM_JULY_AMOUNT        = "7";
	public static final String NAM_AUGUST_AMOUNT      = "8";
	public static final String NAM_SEPTEMBER_AMOUNT   = "9";
	public static final String NAM_OCTOBER_AMOUNT     = "10";
	public static final String NAM_NOVEMBER_AMOUNT    = "11";
	public static final String NAM_DECEMBER_AMOUNT    = "12";
	public static final String NAM_JANUARY_AMOUNT     = "1";
	public static final String NAM_FEBRUARY_AMOUNT    = "2";
	public static final String NAM_MARCH_AMOUNT       = "3";
	public static final String NAM_APRIL_AMOUNT       = "4";
	public static final String NAM_MAY_AMOUNT         = "5";
	public static final String NAM_EXPECTED_MONTH     = "KpN";
	public static final String NAM_INCOME_TAX_TYPE    = "ېŋ敪";
	public static final String NAM_ADJUSTMENT_TYPE    = "N敪";
	public static final String NAM_SELF_WIDOW_TYPE    = "{l敪1";
	public static final String NAM_SELF_HANDICAP_TYPE = "{l敪2";
	public static final String NAM_SELF_STUDENT_TYPE  = "{l敪3";
	public static final String NAM_SPOUSE_INTEND_TYPE = "zҋ敪";
	public static final String NAM_GENERAL_DEPENDENT  = "ʕ}{e";
	public static final String NAM_SPECIFIC_DEPENDENT = "}{e";
	public static final String NAM_ELDERLY_DEPENDENT  = "Vl}{e";
	public static final String NAM_LIVE_WITH_ELD_REL  = "Ve";
	public static final String NAM_LIVE_WITH_HANDI_GE = "";
	public static final String NAM_LIVE_WITH_HANDI_SP = "";
	public static final String NAM_LIVE_WITH_HANDI_EL = "Vl";
	public static final String NAM_LIVE_WITH_HANDI_ER = "Ve";
	public static final String NAM_GENERAL_HANDICAP   = "ʏQ";
	public static final String NAM_SPECIFIC_HANDICAP  = "ʏQ";
	public static final String NAM_DEPENDENT_COUNT    = "}{̐";
	public static final String NAM_LIVE_WITH_TYPE     = "敪";
	public static final String NAM_SPOUSE_TYPE        = "z敪";
	public static final String NAM_DEPENDENT_TYPE     = "}{敪";
	public static final String NAM_HANDICAP_TYPE      = "Qҋ敪";
	public static final String NAM_UNIT_AMOUNT        = "vZP";
	public static final String NAM_MIDWAY_ENTER       = "r";
	public static final String NAM_MIDWAY_TYPE        = "rЋ敪";
	public static final String NAM_FORMER_INCOME      = "OΖ";
	public static final String NAM_FORMER_INSURANCE   = "OΖЉی";
	public static final String NAM_FORMER_TAX         = "OΖ揊";
	public static final String NAM_CALC_STATUS        = "Xe[^X";
	public static final String NAM_ADJUST_YEAR        = "N";
	public static final String NAM_ADJUST_STATUS      = "Xe[^X";
	public static final String NAM_TAX_GAP            = "";
	public static final String NAM_FINAL_INCOME_TAX   = "NŊz";
	public static final String NAM_INCOME_DEDUCT_SUM  = "Tv";
	public static final String NAM_INCOME_TAX_SUM     = "Ōv";
	public static final String NAM_TAXED_PAYMENT_SUM  = "ېŎxv";
	public static final String NAM_HEA_QUALIFICATION  = "Nی}{Ҏi";
	public static final String NAM_QUALIFIED_DATE     = "F";
	public static final String NAM_DISQUALIFIED_DATE  = "폜";
	public static final String NAM_VIEW_INDEX         = "\";
	public static final String NAM_CODE_ID            = "R[h敪";
	public static final String NAM_CODE_CODE          = "R[h";
	public static final String NAM_CODE_NAME          = "R[h";
	public static final String NAM_EXPRESSION         = "vZ";
	
	public static final String CAP_INSURANCE_DEDUCTION  = "یT";
	public static final String NAM_GENERAL_LIFE_INS     = "ʂ̐ی";
	public static final String NAM_PRIVATE_PENSION      = "lNی";
	public static final String NAM_LIFE_INS_DEDUCTION   = "یTz";
	public static final String NAM_EARTHQUAKE_INS       = "nkی";
	public static final String NAM_LONG_TERM_DAMAGE_INS = "Qی";
	public static final String NAM_DAMAGE_INS_DEDUCTION = "QیTz";
	public static final String NAM_SOCIAL_INS_DEDUCTION = "ЉیTz";
	public static final String NAM_MUTUAL_AID_DEDUCTION = "ϊ|Tz";
	public static final String CAP_SPOUSE_SP_DEDUCTION  = "zғʍT";
	public static final String NAM_SPOUSE_SUM_INCOME    = "z҂̍v";
	public static final String NAM_SPOUSE_SP_DEDUCTION  = "zғʍTz";
	public static final String CAP_HOUSE_LOAN_DEDUCTION = "ZؓʍT";
	public static final String NAM_HOUSE_LOAN_DEDUCTION = "ZؓTz";
	public static final String CAP_ADJUSTMENT_ITEMS     = "";
	public static final String NAM_ALLOWANCE_ADJUSTMENT = "xz";
	public static final String NAM_TAX_FREE_ADJUSTMENT  = "ېŒz";
	public static final String NAM_SOC_INS_ADJUSTMENT   = "Љیz";
	public static final String NAM_TAX_INC_ADJUSTMENT   = "Œz";
	public static final String NAM_WITHHOLD_SLIP_NOTES  = "򒥎[Ev";
	public static final String NAM_DEPENDENCE_DEDUCTION = "}{T";
	
	public static final String NAM_DEPENDENCE_DEDUC_OTHER  = "}{T";
	public static final String NAM_DEPENDENCE           = "}{";
	public static final String NAM_PAYMENT_ALLOWANCE    = "E蓖";
	public static final String NAM_PAYMENT_ALLOWANCE_OTHER  = "^";
	public static final String NAM_BONUS_ALLOWANCE_OTHER      = "ܗ^";
	public static final String NAM_TOTAL_ADJ_ALLOWANCE  = "^A蓖Aܗ^̍v";
	public static final String NAM_FORMER_PAYMENT       = "OΖ拋^";
	public static final String NAM_PAY_BONUS           = "^Eܗ^";
	
	public static final String NAM_ADJUSTMENT_ALLOWANCE = "N";
	
	public static final String NAM_PAY_DAY                 = "x";
	public static final String NAM_TAX_FREE_AMOUNT         = "ېŊz";
	public static final String NAM_TAX_PAY_AMOUNT          = "ېŎxz";
	public static final String NAM_SOC_INS_DEDUCTION       = "Еۓ̍Tz";
	public static final String NAM_AFTER_DEDUCT_INCOME     = "ЕۓT㋋^̋z";
	public static final String NAM_VARIOUS_DEDUCTION       = "Tz";
	public static final String NAM_WIDOW                   = "Ǖv";
	public static final String NAM_LIVE_WITH_SPECIAL_HANDI = "ʏQ";
	public static final String NAM_SPOUSE_INTEND_ELDERLY   = "Vlz";
	public static final String NAM_SPOUSE_INTEND_GENERAL   = "ʔz";
	public static final String NAM_WIDOW_GENERAL           = "ʉǕw";
	public static final String NAM_WIDOW_SPECIAL           = "ʉǕw";
	public static final String NAM_STUDENT_GENERAL         = "ΘJw";
	public static final String NAM_DEPEND_DEDUCTION        = "}{T}{e";

	public static final String NAM_SELF_DEPEND_DEDUCTION   = "}{T{l";
	public static final String NAM_SPOUSE_DEPEND_DEDUCTION = "}{Tz";
	// 򒥎닋^o͌
	public static final int    CNT_ADJ_PAYMENT_MONTH     = 12; 
	// 򒥎ܗ^o͌
	public static final int    CNT_ADJ_BONUS_MONTH       = 4;
	public static final int    CNT_OUT_BONUS_MONTH       = 6;

	public static final String NAM_ADJ_PAYMENT_ALLOWANCE="A蓖z";
	public static final String NAM_ADJ_PAYMENT_TAX="^A蓖Ŋz";
	public static final String NAM_ADJ_BONUS_ALLOWANCE="ܗ^z";
	public static final String NAM_ADJ_BONUS_TAX="ܗ^Ŋz";
	public static final String NAM_ADJ_MIDWAY_ALLOWANCE="rAz";
	public static final String NAM_ADJ_MIDWAY_TAX="rAŊz";
	public static final String NAM_ADJ_TOTAL_ALLOWANCE="xzv";
	public static final String NAM_ADJ_TOTAL_INCOME="Ŋzv";
	public static final String NAM_ADJ_AFTER_DEDUCT_INCOME="^T̋^̋z";
	public static final String NAM_ADJ_PAY_INS_DEDUCTION="Љی^̍T";
	public static final String NAM_ADJ_SOCIAL_INS_DEDUCTION="\ɂЉی̍T";
	public static final String NAM_ADJ_MUTUAL_AID_DEDUCTION="\ɂ鏬K͊Ƌϓ|̍T";
	public static final String NAM_ADJ_LIFE_INS_DEDUCTION="ی̍Tz";
	public static final String NAM_ADJ_DAMAGE_INS_DEDUCTION="Qی̍Tz";
	public static final String NAM_ADJ_SPOUSE_SP_DEDUCTION="zғʍTz";
	public static final String NAM_ADJ_DEPENDENTS_DEDUCTION="zҁA}{AbyяQғ̍Tz̍vz";
	public static final String NAM_ADJ_CALC_TAXED_INCOME="ېŋ^z";
	public static final String NAM_ADJ_CALC_INCOME_TAX="ZoNŊz";
	public static final String NAM_ADJ_FINAL_INCOME_TAX="NŊz";
	public static final String NAM_ADJ_TAX_GAP="ߊz͕sz";
	public static final String NAM_ADJ_CALC_GAP    = "Nɂߕs";

	public static final String NAM_OUTPUT_DETAIL = "o͓e"    ;
	public static final String NAM_SPECIFY_MONTH = "Nw"    ;
	public static final String NAM_PAYDAY        = "xw"  ;
	public static final String NAM_COMPANY_CODE  = "ЃR[h"  ;
	public static final String NAM_RECORD_LENGTH = "R[h"  ;
	public static final String NAM_TYPE_CODE     = "ʃR[h"  ;
	public static final String NAM_CODE_TYPE     = "R[h敪"  ;
	public static final String NAM_RECORD_TYPE   = "R[h敪";
	public static final String NAM_END_RECORD    = "ŏIR[h";
	public static final String NAM_DEADLINE_DATE = "["      ;

	public static final String NAM_CO_ADDRESS    = "ЏZ";
	public static final String NAM_COMPANY_NAME  = "Ж";

	public static final String NAM_SELF_TYPE    = "{l敪";
	public static final String NAM_DEAD_RETIREMENT = "SސE";
	public static final String NAM_SELF_DISASTER   = "ЊQ";
	public static final String NAM_FOREIGNER       = "Ol";
	
	public static final String NAM_ALLOWANCE_ITEM  = "x";
	public static final String NAM_DEDUCTION_ITEM  = "T";

	public static final String NAM_OUT_ALLOWANCE_18_1  = "蓖18-1"  ;
	public static final String NAM_OUT_EFFORT_OVER     = "ʁEc";
	public static final String NAM_OUT_ALLOWANCE19_5   = "蓖19-5"  ;
	public static final String NAM_OUT_HOLIDAY         = "x"      ;
	public static final String NAM_OUT_WORK            = "ғ"      ;
	public static final String NAM_OUT_CHANG_WORK      = "E"      ;
	public static final String NAM_OUT_CUT_FOR_ABSENCE = "Όz"  ;
	public static final String NAM_OUT_ALLOWANCE20_2   = "蓖20-2"  ;
	public static final String NAM_OUT_ALLOWANCE20_3   = "蓖20-3"  ;

	
	public static final String NAM_OUT_UNEMPLOY_BASIS   = "ٕۑΏۊ";
	public static final String NAM_OUT_TOTAL_SOC_INS    = "Еۍvz"  ;
	public static final String NAM_OUT_TOTAL_TAX_FREE   = "ېōvz";
	public static final String NAM_OUT_TAXATION         = "ېőΏۊz"  ;
	public static final String NAM_OUT_TRANS_PREV_MONTH = "OJzz"  ;
	public static final String NAM_OUT_TRANS_NEXT_MONTH = "Jzz"  ;
	public static final String NAM_OUT_ABSENCE            = "";
	public static final String NAM_OUT_LATE_EARLY        = "x";
	public static final String NAM_OUT_INCOME_RATE       = "ŗ";

	public static final String NAM_OUT_POSITION         = "E";
	
	public static final String NAM_OUT_OUTPUT_ID         = "{^ԍ";
	public static final String NAM_OUT_OUTPUT_NAME       = "{^";
	public static final String NAM_SAVE_AND_OUT          = "ۑyяo";
	public static final String NAM_OUT_DETAIL_NAME       = "o͓e";

	public static final String NAM_SAVE                  = "ۑ";
	
	public static final String NAM_OUT_SELECT_BUTTON     = "Ieo";
	public static final String NAM_OUT_SHORT_BUTTON      = "V[gJbgo";
	public static final String NAM_OUT_SAVE_DETAIL       = "o͓eۑ";

	public static final String NAM_STATION_CODE            = "R[h";
	public static final String NAM_CALC_DATE               = "vZN";
	public static final String NAM_PAY_BASIC_DATE          = "xb";
	public static final String NAM_PAY_BASIC_DATE1         = "xb1";
	public static final String NAM_PAY_BASIC_DATE2         = "xb2";
	public static final String NAM_PAY_BASIC_DATE3         = "xb3";
	public static final String NAM_PAY_AMOUNT              = "K̊z";
	public static final String NAM_PAY_AMOUNT1             = "K̊z1";
	public static final String NAM_PAY_AMOUNT2             = "K̊z2";
	public static final String NAM_PAY_AMOUNT3             = "K̊z3";
	public static final String NAM_GOODS_AMOUNT            = "̊z";
	public static final String NAM_GOODS_AMOUNT1           = "̊z1";
	public static final String NAM_GOODS_AMOUNT2           = "̊z2";
	public static final String NAM_GOODS_AMOUNT3           = "̊z3";
	public static final String NAM_REWARD_TOTAL            = "Vv";
	public static final String NAM_REWARD_TOTAL1           = "Vv1";
	public static final String NAM_REWARD_TOTAL2           = "Vv2";
	public static final String NAM_REWARD_TOTAL3           = "Vv3";
	public static final String NAM_REWARD_TOTAL_SUM        = "Vz";
	public static final String NAM_AVERAGE_THREE_MONTHS    = "3";
	public static final String NAM_EDIT_AVERAGE            = "C";
	public static final String NAM_HEALTH_BEF_GRADE        = "ۏ]O";
	public static final String NAM_HEALTH_BEF_PREMIUM      = "ۏ]Oی";
	public static final String NAM_PENSION_BEF_GRADE       = "N]O";
	public static final String NAM_PENSION_BEF_PREMIUM     = "N]Oی";
	public static final String NAM_HEALTH_DEC_GRADE        = "ی蓙";
	public static final String NAM_HEALTH_DEC_PREMIUM      = "یی";
	public static final String NAM_PENSION_DEC_GRADE       = "N蓙";
	public static final String NAM_PENSION_DEC_PREMIUM     = "Nی";
	public static final String NAM_RETROACTIVE_PAYMENT     = "kyxz";
	public static final String NAM_RAISE_DOWN_SALARY_DATE  = "~N";
	public static final String NAM_RAISE_DOWN_SALARY_BASIS = "~̌z";
	public static final String NAM_CALC_RESULT             = "vZ";
	
	public static final String NAM_BONUS_ALLOWANCE_01  = "ܗ^xz01";
	public static final String NAM_BONUS_ALLOWANCE_02  = "ܗ^xz02";
	public static final String NAM_BONUS_ALLOWANCE_03  = "ܗ^xz03";
	public static final String NAM_BONUS_ALLOWANCE_04  = "ܗ^xz04";
	public static final String NAM_BONUS_ALLOWANCE_05  = "ܗ^xz05";
	public static final String NAM_BONUS_ALLOWANCE_06  = "ܗ^xz06";
	public static final String NAM_BONUS_ALLOWANCE_07  = "ܗ^xz07";
	public static final String NAM_BONUS_ALLOWANCE_08  = "ܗ^xz08";
	public static final String NAM_BONUS_ALLOWANCE_09  = "ܗ^xz09";
	public static final String NAM_BONUS_ALLOWANCE_10  = "ܗ^xz10";
	public static final String NAM_BONUS_ALLOWANCE_11  = "ܗ^xz11";
	public static final String NAM_BONUS_ALLOWANCE_12  = "ܗ^xz12";
	public static final String NAM_BONUS_ALLOWANCE_13  = "ܗ^xz13";
	public static final String NAM_BONUS_ALLOWANCE_14  = "ܗ^xz14";
	public static final String NAM_BONUS_ALLOWANCE_15  = "ܗ^xz15";
	public static final String NAM_BONUS_ALLOWANCE_16  = "ܗ^xz16";
	public static final String NAM_BONUS_ALLOWANCE_17  = "ܗ^xz17";
	public static final String NAM_BONUS_ALLOWANCE_18  = "ܗ^xz18";
	public static final String NAM_BONUS_ALLOWANCE_19  = "ܗ^xz19";
	public static final String NAM_BONUS_ALLOWANCE_20  = "ܗ^xz20";
	public static final String NAM_BONUS_DEDUCTION_01  = "ܗ^Tz01";
	public static final String NAM_BONUS_DEDUCTION_02  = "ܗ^Tz02";
	public static final String NAM_BONUS_DEDUCTION_03  = "ܗ^Tz03";
	public static final String NAM_BONUS_DEDUCTION_04  = "ܗ^Tz04";
	public static final String NAM_BONUS_DEDUCTION_05  = "ܗ^Tz05";
	public static final String NAM_BONUS_DEDUCTION_06  = "ܗ^Tz06";
	public static final String NAM_BONUS_DEDUCTION_07  = "ܗ^Tz07";
	public static final String NAM_BONUS_DEDUCTION_08  = "ܗ^Tz08";
	public static final String NAM_BONUS_DEDUCTION_09  = "ܗ^Tz09";
	public static final String NAM_BONUS_DEDUCTION_10  = "ܗ^Tz10";
	public static final String NAM_BONUS_DEDUCTION_11  = "ܗ^Tz11";
	public static final String NAM_BONUS_DEDUCTION_12  = "ܗ^Tz12";
	public static final String NAM_BONUS_DEDUCTION_13  = "ܗ^Tz13";
	public static final String NAM_BONUS_DEDUCTION_14  = "ܗ^Tz14";
	public static final String NAM_BONUS_DEDUCTION_15  = "ܗ^Tz15";
	public static final String NAM_BONUS_DEDUCTION_16  = "ܗ^Tz16";
	public static final String NAM_BONUS_DEDUCTION_17  = "ܗ^Tz17";
	public static final String NAM_BONUS_DEDUCTION_18  = "ܗ^Tz18";
	public static final String NAM_BONUS_DEDUCTION_19  = "ܗ^Tz19";
	public static final String NAM_BONUS_DEDUCTION_20  = "ܗ^Tz20";
	
	public static final String NAM_CITY_CODE         = "sR[h"  ;
	public static final String NAM_CITY_NAME         = "s"      ;
	public static final String NAM_CITY_KANA         = "sJi"    ;
	public static final String NAM_CITY_ACCOUNT      = "sԍ";
	public static final String NAM_CITY_ACCOUNT_NAME1= "1"       ;
	public static final String NAM_CITY_ACCOUNT_NAME2= "2"       ;
	public static final String NAM_DESIGNATED_NUMBER = "wԍ"      ;
	public static final String NAM_MASTER_OFFICE     = "܂Ƃߋ"  ;
	public static final String NAM_CITY_POSTAL_CODE  = "sX֔ԍ";
	public static final String NAM_CITY_ADDRESS1     = "sZ1"   ;
	public static final String NAM_CITY_ADDRESS2     = "sZ2"   ;
	public static final String NAM_CITY_OFFICE1      = "ꖼ1"       ;
	public static final String NAM_CITY_OFFICE2      = "ꖼ2"       ;
	public static final String NAM_CITY_PHONE        = "sdbԍ";
	
	public static final String NAM_DETAIL_MONTH    = "ސEהN";
	public static final String NAM_CITY_CHANGES    = "ٓL"    ;
	public static final String NAM_RETIRE_COUNT    = "ސEl"    ;
	public static final String NAM_CITY_PAY_AMOUNT = "xz"    ;
	public static final String NAM_CITY_TAX        = "s"    ;
	public static final String NAM_PREFECTURE_TAX  = "{"    ;
	
	public static final String NAM_LEAVE_JOB_DAY   = "E"    ;
	
	
	/* ʍږ */
	public static final String NAM_COMMON_NAME = "";
	public static final String NAM_COMMON_CODE = "R[h";
	public static final String NAM_COMMON_TYPE = "敪";
	public static final String NAM_COMMON_FLAG = "tO";
	public static final String NAM_COMMON_SEQ  = "A";
	public static final String NAM_COMMON_SUM  = "v";
	public static final String NAM_COMMON_TIME = "";
	public static final String NAM_COMMON_DAY  = "";
	public static final String NAM_COMMON_ALLO = "蓖";
	public static final String NAM_COMMON_CNT1 = "";
	public static final String NAM_COMMON_SEN  = "";
	public static final String NAM_COMMON_YEN  = "~";
	public static final String NAM_COMMON_ITEM = "";
	public static final String NAM_COMMON_OUT  = "o";
	public static final String NAM_COMMON_CSV  = "CSV";
	public static final String NAM_SEPARATOR   = "E";
	public static final String BRACKET_LEFT    = "y";
	public static final String BRACKET_RIGHT   = "z";
	public static final String NAM_COMMON_POSTAL = "";
	public static final String NAM_COMMON_CONST  = "萔";
	
	/* ڒ */
	public static final int LEN_PASSWORD        = 32;
	public static final int LEN_MIN_PASSWORD    = 4;
	public static final int LEN_K_CODE          = 10;
	public static final int LEN_K_NAME          = 16;
	public static final int LEN_STATION_CODE    = 4;
	public static final int LEN_ROUTE_CODE      = 4;
	public static final int LEN_REMARKS         = 64;
	public static final int LEN_GRADE           = 2;
	public static final int LEN_MONEY_AMOUNT    = 8;
	public static final int LEN_POSTAL_CODE     = 8;
	public static final int LEN_ADDRESS         = 64;
	public static final int LEN_PHONE_NUMBER    = 13;
	public static final int LEN_BANK_CODE       = 4;
	public static final int LEN_BRANCH_CODE     = 3;
	public static final int LEN_ACCOUNT_NO      = 7;
	public static final int LEN_DISTANCE_INT    = 3;
	public static final int LEN_DISTANCE_DEC    = 2;
	public static final int LEN_UNIT_AMOUNT_INT = 8;
	public static final int LEN_UNIT_AMOUNT_DEC = 2;
	public static final int LEN_TIME_INT        = 3;
	public static final int LEN_TIME_DEC        = 2;
	public static final int LEN_MONTH_DAY       = 2;
	public static final int LEN_WITHHOLD_NOTES  = 64;
	public static final int LEN_PAYD_HOLIDAY    = 2;
	public static final int LEN_PAYD_HOLI_MAX   = 40;
	public static final int LEN_INS_RATIO_INT   = 3;
	public static final int LEN_INS_RATIO_DEC   = 3;
	public static final int LEN_FB_TYPE_CODE    = 2;
	public static final int LEN_FB_COMPANY_CODE = 10;
	public static final int LEN_FB_RECORD_LENGTH= 3;
	public static final int LEN_FB_COMPANY_NAME = 40;
	public static final int LEN_FB_CO_ADDRESS   = 50;
	
	public static final int LEN_CITY_CODE          = 6;
	public static final int LEN_CITY_NAME          = 10;
	public static final int LEN_CITY_KANA          = 20;
	public static final int LEN_CITY_ACCOUNT       = 14;
	public static final int LEN_CITY_ACCOUNT_NAME1 = 8;
	public static final int LEN_CITY_ACCOUNT_NAME2 = 8;
	public static final int LEN_DESIGNATED_NUMBER  = 15;
	public static final int LEN_MASTER_OFFICE      = 15;
	public static final int LEN_CITY_POSTAL_CODE   = 10;
	public static final int LEN_CITY_ADDRESS1      = 25;
	public static final int LEN_CITY_ADDRESS2      = 25;
	public static final int LEN_CITY_OFFICE1       = 16;
	public static final int LEN_CITY_OFFICE2       = 16;
	public static final int LEN_CITY_PHONE         = 17;
	
	public static final int LEN_RETIRE_COUNT    = 3;
	public static final int LEN_CITY_PAY_AMOUNT = 10;
	public static final int LEN_CITY_TAX        = 9;
	public static final int LEN_PREFECTURE_TAX  = 9;
	public static final int LEN_OUTPUT_VALUE    = 8;
	
	public static final int LEN_OUTPUT_REMARKS1 = 64;
	public static final int LEN_OUTPUT_REMARKS2 = 255;
	
	public static final int LEN_EXPRESSION      = 255;
	public static final int LEN_VIEW_INDEX      = 3;
	
	public static final int LEN_LICENSE_CODE      = 8;
	public static final int LEN_ACCIDENT_CONTENTS = 8;
	
	/* ͐ */
	public static final String REG_DELETE      = "0|1"    ;
	public static final String REG_SB_NUM_ALP  = "[0-9-]*";
	public static final String REG_DECIMAL_PRE = "^(([1-9]\\d{0,";
	public static final String REG_DECIMAL_MID = "})|0)(\\.\\d{1,";
	public static final String REG_DECIMAL_AFT = "})?$";
	public static final String REG_INTEGER     = "^[-]?[0-9]+";
	
	/* ʖA{^ */
	public static final String TTL_MAIN_MENU              = "Cj[";
	public static final String TTL_SUB_MENU               = "Tuj[";
	public static final String TTL_MENU_INPUT             = "Αӓ";
	public static final String TTL_MENU_MANAGE            = "ΑӊǗ";
	public static final String TTL_MENU_PAYROLL           = "^Ǘ";
	public static final String TTL_MENU_HUMAN             = "lǗ";
	public static final String TTL_MENU_SYSTEM            = "VXeݒ1";
	public static final String TTL_MENU_SYSTEM2           = "VXeݒ2";
	public static final String TTL_ATTENDANCE_LIST        = "Αӈꗗ";
	public static final String TTL_ATTENDANCE_CARD        = "Αӓ";
	public static final String TTL_EMPLOYEE_SELECT        = "Јꗗ(Α)";
	public static final String TTL_EMPLOYEE_LIST          = "Јꗗ";
	public static final String TTL_ATTENDANCE_FIX         = "m菈";
	public static final String TTL_DATE_ALLOWANCE         = "t蓖Ǘ";
	public static final String TTL_ROUTE                  = "[g}X^ێ";
	public static final String TTL_SUPERIOR               = "T|[^[ݒ";
	public static final String TTL_SUPPORT                = "xǗ";
	public static final String TTL_PAID_HOLIDAY           = "LxɊǗ";
	public static final String TTL_PAY_CALCULATE          = "^vZ";
	public static final String TTL_AVALIABLE_STA          = "ScƏǗ";
	public static final String TTL_POSITION_MAINT         = "Eʃ}X^ێ";
	public static final String TTL_EMPLOYMENT_MAINT       = "ٗp}X^ێ";
	public static final String TTL_CONFIRM_ATT_LIST       = "ΑӊmF";
	public static final String TTL_PAYMENT_CARD           = "^׊mF";
	public static final String TTL_PAYMENT_LIST           = "^f[^ꗗ";
	public static final String TTL_BONUS_CARD             = "ܗ^וҏW";
	public static final String TTL_BONUS_LIST             = "ܗ^f[^ꗗ";
	public static final String TTL_HUMAN_LIST             = "lꗗ";
	public static final String TTL_HISTORY_LIST           = "l{Kp";
	public static final String TTL_HUMAN_CARD             = "lQ";
	public static final String TTL_HUMAN_BASIS            = "l{ҏW";
	public static final String TTL_HUMAN_CALC             = "l^ҏW";
	public static final String TTL_HUMAN_MANAGE           = "lǗҏW";
	public static final String TTL_HUMAN_OUTPUT           = "lo";
	public static final String TTL_HUMAN_UPLOAD           = "lAbv[h";
	public static final String TTL_SOC_INSURANCE          = "ЉیvZ";
	public static final String TTL_HUMAN_HISTORY          = "l񗚗Q";
	public static final String TTL_ADJUSTMENT_CALC        = "NvZ";
	public static final String TTL_ADJUSTMENT_LIST        = "Nf[^ꗗ";
	public static final String TTL_ADJUSTMENT_CARD        = "Nf[^";
	public static final String TTL_COMMUTE_CALC           = "ʋΎ蓖vZ";
	public static final String TTL_ADD_HISTORY            = "ǉǗ";
	public static final String TTL_FIRM_BANKING           = "FBf[^o";
	public static final String TTL_CITY                   = "s撬}X^ێ";
	public static final String TTL_RETIRE_DETAIL          = "ސEאݒ";
	public static final String TTL_EX_CODE                = "ǉR[hێ";
	public static final String TTL_CO_FINANCE_EDIT        = "s}X^ExX}X^ҏW";
	public static final String TTL_EXPRESSION             = "vZݒ";
	public static final String TTL_TRAINING               = "C}X^ێ";
	
	public static final String NAM_LOGOUT                 = "OAEg";
	public static final String NAM_MAKE_NEW_DATA          = "VKo^";
	public static final String NAM_SEARCH                 = "";
	public static final String NAM_REGIST                 = "o^";
	public static final String NAM_OUTPUT_DATA            = "o";
	public static final String NAM_EDIT                   = "ҏW";
	public static final String NAM_CHANGE                 = "ύX";
	public static final String NAM_DELETE                 = "폜";
	public static final String NAM_SELECT                 = "I";
	public static final String NAM_REFER                  = "Q";
	public static final String NAM_APPLY                  = "Kp";
	public static final String NAM_INPUT                  = "";
	public static final String NAM_RE_SEARCH              = "ĕ\";
	public static final String NAM_CONFIRM_ATTENDANCE     = "Α";
	public static final String NAM_CONFIRM_PAYMENT        = "^";
	public static final String NAM_CONFIRM_BONUS          = "ܗ^";
	public static final String NAM_TO_EXPRESS_CARD        = "Z";
	public static final String NAM_TO_LIST                = "ꗗ";
	public static final String NAM_TO_PAY_CALCULATE       = "^vZ";
	public static final String NAM_TO_BONUS_CALCULATE     = "ܗ^vZ";
	public static final String NAM_PAY_CALCULATE_EACH     = "ʋ^vZ";
	public static final String NAM_BONUS_CALCULATE_EACH   = "ʏܗ^vZ";
	public static final String NAM_OUTPUT_PAYMENT         = "ʋ^׏o";
	public static final String NAM_OUTPUT_BONUS           = "ʏܗ^׏o";
	public static final String NAM_ALL_OUTPUT_PAYMENT     = "^׏o";
	public static final String NAM_ALL_OUTPUT_BONUS       = "ܗ^׏o";
	public static final String NAM_PAY_CALCULATE          = "^vZ";
	public static final String NAM_BONUS_CALCULATE        = "ܗ^vZ";
	public static final String NAM_TAX_CALCULATE          = "@TvZ";
	public static final String NAM_SOC_INSURANCE_CALC     = "ЉیvZ";
	public static final String NAM_PAY_DATA_CALC          = "^f[^쐬";
	public static final String NAM_PAY_DATA_CALC_EACH     = "ʋ^f[^쐬";
	public static final String NAM_TAX_CALCULATE_EACH     = "ʌvZ";
	public static final String NAM_FIX_ATTENDANCE_EACH    = "ʊm菈";
	public static final String NAM_OUTPUT_FB_DATA         = "FBf[^o";
	public static final String NAM_OUTPUT_TRANSFER_REQ    = "U˗";
	public static final String NAM_OUTPUT_DENOMINATION    = "\";
	public static final String NAM_OUTPUT_PAYROLL         = "䒠";
	public static final String NAM_REFER_HISTORY          = "Q";
	public static final String NAM_PAYMENT_LIST           = "^ꗗ";
	public static final String NAM_BONUS_LIST             = "ܗ^ꗗ";
	public static final String NAM_OUTPUT_ADJUSTMENT      = "Nf[^o";
	public static final String NAM_INPUT_ADJUSTMENT       = "Nf[^";
	public static final String NAM_INPUT_ADJUSTMENT_ABB   = "N";
	public static final String NAM_CALC_ADJUSTMENT        = "NvZ";
	public static final String NAM_NO_DATA_ADJUSTMENT     = "Nf[^쐬";
	public static final String NAM_REFER_WITHHOLD_BOOK    = "򒥎Q";
	public static final String NAM_NEXT_ADJUST_YEAR       = "Ni";
	public static final String NAM_BACK_ADJUST_YEAR       = "N߂";
	public static final String NAM_WITHHOLD_SLIP          = "򒥎[";
	public static final String NAM_WITHHOLD_BOOK          = "򒥎";
	public static final String NAM_PAYMENT_LEDGER         = "䒠";
	public static final String NAM_WITHHOLD_SLIP_EACH     = "ʌ򒥎[";
	public static final String NAM_WITHHOLD_BOOK_EACH     = "ʌ򒥎";
	public static final String NAM_PAYMENT_LEDGER_EACH    = "ʒ䒠";
	public static final String NAM_OUT_LEAVE_JOB_LIST    = "Eؖo";
	
	public static final String NAM_TO_ADJUSTMENT_LIST     = "Nꗗ";
	public static final String NAM_TO_ADJUSTMENT_CALC     = "NvZ";
	public static final String NAM_OUTPUT_LUMP_DATA       = "ꊇf[^o";
	public static final String NAM_REGIST_AND_CALCULATE   = "o^yьvZ";
	
	public static final String NAM_TO_RETIRE_DETAIL     = "ސEאݒ";
	public static final String NAM_TO_FIRM_BANKING     = "FBf[^o͂";

	public static final String NAM_FB_RESIDENCE     = "ZFBf[^";
	public static final String NAM_FB_PAYMENT       = "^FBf[^";
	public static final String NAM_FB_BONUS         = "FBf[^o";
	

	
	public static final String NAM_BONUS_DATA_CALC        = "ܗ^f[^쐬";
	public static final String NAM_PAID_HOLIDAY_CALCULATE = "LxɌvZ";
	public static final String NAM_NEXT_CALC_CURRENT      = "vZi";
	public static final String NAM_BACK_CALC_CURRENT      = "vZ߂";
	public static final String NAM_BACK_STAT_CURRENT      = "Wv߂";
	public static final String NAM_OUTPUT_PAY_DATA        = "^f[^o";
	public static final String NAM_OUTPUT_BONUS_DATA      = "f[^o";
	public static final String NAM_IF_PAY_DATA            = "^IFo";
	public static final String NAM_FIX_ATTENDANCE         = "m菈";
	public static final String NAM_OUTPUT_MONTHLY_REPORT  = "Ζf[^o";
	public static final String NAM_OUTPUT_ATTENDANCE_BOOK = "oΕo";
	public static final String NAM_OUTPUT_ATTENDANCE_LIST = "ΑӏWv\o";
	public static final String NAM_OUTPUT_ATTENDANCE_DATA = "ΑӃf[^o";
	public static final String NAM_CHANGE_STATION         = "ΏۉcƏύX";
	public static final String NAM_SEARCH_INCOMPATIBILITY = "s";
	public static final String NAM_LIST_INCOMPATIBILITY   = "sꗗ";
	public static final String NAM_INIT_PASSWORD          = "pX[h";
	public static final String NAM_SELECT_FILE            = "t@CI";
	public static final String NAM_UPLOAD                 = "Abv[h";
	public static final String NAM_UPLOAD_TMP             = "ev[g";
	public static final String NAM_EDIT_HUMAN_BASIC       = "{ҏW";
	public static final String NAM_EDIT_HUMAN_PAYMENT     = "^ҏW";
	public static final String NAM_EDIT_HUMAN_PERSONNEL   = "ǗҏW";
	public static final String NAM_VIEW_HUMAN             = "lQ";
	public static final String NAM_BATCH_APPLY            = "ꊇKp";
	public static final String NAM_TO_HUMAN_LIST          = "lꗗ";
	public static final String NAM_TO_HISTORY_LIST        = "Kpꗗ";
	public static final String NAM_OUTPUT_HUMAN_DATA      = "lo";
	public static final String NAM_SELECT_OPTION_ALL      = "SI";
	public static final String NAM_SELECT_OPTION          = "I";
	public static final String NAM_RELEASE_OPTION_ALL     = "S";
	public static final String NAM_RELEASE_OPTION         = "";
	public static final String NAM_ADD_ROW                = "sǉ";
	public static final String NAM_DELETE_ROW             = "s폜";
	public static final String NAM_HUMAN_INSURANCE        = "Љی";
	public static final String NAM_HUMAN_FAMILY_INSURE    = "Ƒ(ی)";
	public static final String NAM_HUMAN_RESIDENCE_TAX    = "Z";
	public static final String NAM_HUMAN_INCOME_TAX       = "";
	public static final String NAM_HUMAN_FAMILY_TAX       = "Ƒ()";
	public static final String NAM_HUMAN_ACCOUNT          = "x@";
	public static final String NAM_HUMAN_COMMUTATION      = "ʋΎ蓖";
	public static final String NAM_HUMAN_CALC_OTHER       = "vZPErГ";
	public static final String NAM_HUMAN_EXTRA            = "Ǘ";
	public static final String NAM_HUMAN_FAMILY           = "Ƒ";
	public static final String NAM_HUMAN_BASIS            = "l{";
	public static final String NAM_ADD_FAMILY_INFO        = "Ƒt";
	public static final String NAM_CHANGE_DEPENDENTS      = "}{ҐXV";
	public static final String NAM_NO_DATA_HUMAN_FAMILY   = "ƑȂ";
	
	
	public static final String NAM_PAY_DATA_COPY_FROM1    = "1 COPY";
	public static final String NAM_PAY_DATA_COPY_FROM2    = "2 COPY";

	public static final String NAM_FUND_PARTICIPATION     = "";
	public static final String NAM_FUND_NOT_PARTICIPATION = "";
	
	/* e햼 */
	public static final String NAM_DEFAULT_FLAG_OFF      = "@"; 
	public static final String NAM_DEFAULT_FLAG_ON       = ""; 
	public static final String NAM_MISSING_INPUT_OFF     = "@";
	public static final String NAM_MISSING_INPUT_OFF_OPT = "";
	public static final String NAM_MISSING_INPUT_ON      = "L"; 
	public static final String NAM_OK                    = "";
	public static final String NAM_NG                    = "~";
	public static final String NAM_RETIREMENT_OFF        = "ݐE";
	public static final String NAM_RETIREMENT_ON         = "ސE";
	public static final String NAM_KILOMETER             = "km";
	public static final String NAM_HISTORY               = ""; 
	public static final String NAM_SELECTION             = "ꗗ"; 
	
	/* ̑ */
	public static final String CMT_INPUT_ATTENDANCE = "ΑӋ敪IĉB";
	public static final String CMT_INPUT_WORK_TYPE  = "`ԋ敪IĉB";
	public static final String CMT_INPUT_TIME_TYPE  = "E敪IĉB";
	public static final String CMT_INPUT_TRAIN      = "/CIĉB";
	public static final String CMT_INPUT_TIME       = "ԏIĉB";
	public static final String CMT_INPUT_ROUTE      = "[gIĉB";
	public static final String CMT_INPUT_ACCIDENT   = "KvΎ/ƒIĉB";
	public static final String CMT_INPUT_REMARKS    = "KvΔl͂ĉB";

	public static final String CMT_OUT_FIRM_BANKING = "o͂FBf[^IĂB";
	public static final String CMT_SPECIFY_MONTH    = "Nw肵ĂB";
	public static final String CMT_DEADLINE_DATE    = "[w肵ĂB";
	public static final String CMT_COMPANY_CODE     = "ЋsR[hIĂBЃR[hȉ͕K{łB";
	public static final String CMT_OUTPUT_OPTION    = "o̓IvVw肵ĂB";
	public static final String CMT_HISTORY_SELECT    = "(ŐVf[^̂ݕ\)";
	
	/* j */
	public static final String NAM_SUNDAY    = "";
	public static final String NAM_MONDAY    = "";
	public static final String NAM_TUESDAY   = "";
	public static final String NAM_WEDNESDAY = "";
	public static final String NAM_THURSDAY  = "";
	public static final String NAM_FRIDAY    = "";
	public static final String NAM_SATURDAY  = "y";
	
	/* s֘A */
	public static final String NAM_NO_TRAINED_ATTENDANCE   = "ΑӖ";
	public static final String NAM_TRAINED_INCOMPATIBILITY = "s";
	public static final String NAM_NO_FELLOW_ATTENDANCE    = "ҋΑӖ";
	public static final String NAM_FELLOW_INCOMPATIBILITY  = "ҕs";
	public static final String NAM_ROUTE_DUPLICATE         = "[gd";
	public static final String NAM_INPUT_INCOMPATIBILITY   = "ΑӖ͗L";
	
	// vZ֘A
	public static final String NAM_EXP_R_CEILING = "؂グ";
	public static final String NAM_EXP_R_FLOOR   = "؂̂";
	public static final String NAM_EXP_R_H_UP    = "ľܓ";
	public static final String NAM_EXP_SCALE_2   = "[_2]";
	public static final String NAM_EXP_SCALE_1   = "[_1]";
	public static final String NAM_EXP_SCALE_0   = "[1]";
	public static final String NAM_EXP_SCALE_1M  = "[2]";
	public static final String NAM_EXP_SCALE_2M  = "[3]";
	public static final String NAM_EXP_SCALE_3M  = "[4]";
	public static final String NAM_EXP_TO_ZERO   = "}CiXȂ[";
	public static final String NAM_EXP_ADD_CONST = "萔ǉ";
	public static final String NAM_EXP_ADD_PARAM = "ϐǉ";
	public static final String NAM_EXP_ADD_ROUND = "[";
	public static final String NAM_EXP_BACK_SPA  = "BackSpace";
	
	/* ΑӋ敪 */
	public static final String ATTENDANCE_LEGAL_HOLIDAY  = "10";	// x
	public static final String ATTENDANCE_PRESENCE       = "20";	// o
	public static final String ATTENDANCE_WITHOUT_NOTICE = "30";	// f
	public static final String ATTENDANCE_NOTICED        = "35";	// 
	public static final String ATTENDANCE_PAID_HOLIDAY   = "40";	// Lx
	public static final String ATTENDANCE_WORKMENS       = "50";	// JЋx
	public static final String ATTENDANCE_MATERNITY_TERM = "52";	// YOY
	public static final String ATTENDANCE_SICK           = "54";	// ax
	public static final String ATTENDANCE_CHILD_CARE     = "56";	// 玙
	public static final String ATTENDANCE_MARRIAGE       = "60";	// x
	public static final String ATTENDANCE_MATERNITY      = "62";	// oY
	public static final String ATTENDANCE_FAMILY         = "64";	// x
	public static final String ATTENDANCE_OTHER          = "80";	// s
	
	/* ΑӏWv敪 */
	public static final String TOTAL_LEGAL_HOLIDAY         = "10";	// x
	public static final String TOTAL_PRESENCE              = "20";	// o
	public static final String TOTAL_ABSENCE               = "30";	// 
	public static final String TOTAL_PAID_HOLIDAY          = "40";	// Lx
	public static final String TOTAL_INSTITUTIONAL_ABSENCE = "50";	// x
	public static final String TOTAL_WORKMENS              = "60";	// JЋx
	public static final String TOTAL_PARTICULAR_HOLIDAY    = "70";	// ʋx
	public static final String TOTAL_OTHER                 = "80";	// ̑
	
	/* ^敪 */
	public static final String PAYMENT_PER_MONTH = "1";	// 
	public static final String PAYMENT_PER_DAY   = "2";	// 
	public static final String PAYMENT_PER_HOUR  = "3";	// 
	
	/* cƋ敪 */
	public static final String OVERTIME_IS_EFFORT = "1";	// ʗL
	public static final String OVERTIME_IS_TIME   = "2";	// cƗL
	public static final String OVERTIME_IS_NONE   = "3";	// cƖ
	
	/* Lxɋ敪 */
	public static final String PAID_HOLIDAY_NONE  = "6";	// Lx
	/* őƑ */
	public static final int    MAX_FAMILY_COUNT    = 10;	// őƑ
	
	/* x@A */
	public static final int    PAYMENT_MEANS_COUNT = 4;	// x@
	public static final int    PAYMENT_MEANS_SEQ_1 = 0;	// ^U1
	public static final int    PAYMENT_MEANS_SEQ_2 = 1;	// ^U2
	public static final int    PAYMENT_MEANS_SEQ_3 = 2;	// ܗ^U1
	public static final int    PAYMENT_MEANS_SEQ_4 = 3;	// ܗ^U2
	/* x敪 */
	public static final String ALLOWANCE_TYPE_SALARY = "1";	// ^
	public static final String ALLOWANCE_TYPE_BONUS  = "2";	// ܗ^
	/* x@ */
	public static final String PAYMENT_MEANS_ACCOUNT = "2";	// U
	
	/* ʋΎ蓖A */
	public static final int    COMMUTATION_COUNT = 2;	// ʋΎ蓖
	public static final int    COMMUTE_SEQ_1     = 0;	// ʋΎ蓖1
	public static final int    COMMUTE_SEQ_2     = 1;	// ʋΎ蓖2
	/* ʋΎ蓖敪 */
	public static final String COMMUTE_TYPE_FACILITY = "1";	// ʋ@
	public static final String COMMUTE_TYPE_CAR      = "2";	// ʗp
	
	/* ו\@敪 */
	public static final String DISPLAY_ON       = "1";	// \
	public static final String DISPLAY_NOT_ZERO = "2";	// 0~\
	
	/* `ԕ\ݒ͍ڐ */
	public static final int WORK_TYPE_SET_COUNT   = 16;	
	/* E\ݒ͍ڐ */
	public static final int TIME_TYPE_SET_COUNT   = 10;	

	/* z0~ */
	public static final int AMOUNT_ZERO   = 0;	
		
	/* P敪 */
	public static final String UNIT_OVERTIME        = "OVER";	// cƎ蓖P
	public static final String UNIT_LATE_NIGHT      = "LATE";	// [蓖P
	public static final String UNIT_WORK_ON_HOLIDAY = "HOLI";	// cƎ蓖P
	/* o̓IvV */
	public static final String NAM_RETIREMENT_YEAR1    = "ސE1Nȓ";
	public static final String OUT_RETIREMENT_YEAR1    = "3";
	
	// FBf[^ʃR[h
	public static final String FB_PAYMENT_TYPE_CODE = "11";	// ^
	public static final String FB_BONUS_TYPE_CODE   = "12";	// ܗ^
	
	public static final String ADJ_PAYMENT_TARGET   = "0";	// NΏۃf[^(^)
	public static final String ADJ_BONUS_TARGET     = "1";	// NΏۃf[^(ܗ^)
	public static final String ADJ_NO_TARGET        = "2";	// NΏۃf[^(vZȂ)

	public static final String ADJ_PAY_TARGET_MONTH = "12";	// NΏۃf[^
	
	/* ׃R[h */
	public static final String DTL_PAY_ATTENDANCE_01 = "KN01";	// Α01
	public static final String DTL_PAY_ATTENDANCE_02 = "KN02";	// Α02
	public static final String DTL_PAY_ATTENDANCE_03 = "KN03";	// Α03
	public static final String DTL_PAY_ATTENDANCE_04 = "KN04";	// Α04
	public static final String DTL_PAY_ATTENDANCE_05 = "KN05";	// Α05
	public static final String DTL_PAY_ATTENDANCE_06 = "KN06";	// Α06
	public static final String DTL_PAY_ATTENDANCE_07 = "KN07";	// Α07
	public static final String DTL_PAY_ATTENDANCE_08 = "KN08";	// Α08
	public static final String DTL_PAY_ATTENDANCE_09 = "KN09";	// Α09
	public static final String DTL_PAY_ATTENDANCE_10 = "KN10";	// Α10
	public static final String DTL_PAY_ATTENDANCE_11 = "KN11";	// Α11
	public static final String DTL_PAY_ATTENDANCE_12 = "KN12";	// Α12
	public static final String DTL_PAY_ATTENDANCE_13 = "KN13";	// Α13
	public static final String DTL_PAY_ATTENDANCE_14 = "KN14";	// Α14
	public static final String DTL_PAY_ALLOWANCE_01  = "KS01";	// x01
	public static final String DTL_PAY_ALLOWANCE_02  = "KS02";	// x02
	public static final String DTL_PAY_ALLOWANCE_03  = "KS03";	// x03
	public static final String DTL_PAY_ALLOWANCE_04  = "KS04";	// x04
	public static final String DTL_PAY_ALLOWANCE_05  = "KS05";	// x05
	public static final String DTL_PAY_ALLOWANCE_06  = "KS06";	// x06
	public static final String DTL_PAY_ALLOWANCE_07  = "KS07";	// x07
	public static final String DTL_PAY_ALLOWANCE_08  = "KS08";	// x08
	public static final String DTL_PAY_ALLOWANCE_09  = "KS09";	// x09
	public static final String DTL_PAY_ALLOWANCE_10  = "KS10";	// x10
	public static final String DTL_PAY_ALLOWANCE_11  = "KS11";	// x11
	public static final String DTL_PAY_ALLOWANCE_12  = "KS12";	// x12
	public static final String DTL_PAY_ALLOWANCE_13  = "KS13";	// x13
	public static final String DTL_PAY_ALLOWANCE_14  = "KS14";	// x14
	public static final String DTL_PAY_ALLOWANCE_15  = "KS15";	// x15
	public static final String DTL_PAY_ALLOWANCE_16  = "KS16";	// x16
	public static final String DTL_PAY_ALLOWANCE_17  = "KS17";	// x17
	public static final String DTL_PAY_ALLOWANCE_18  = "KS18";	// x18
	public static final String DTL_PAY_ALLOWANCE_19  = "KS19";	// x19
	public static final String DTL_PAY_ALLOWANCE_20  = "KS20";	// x20
	public static final String DTL_PAY_DEDUCTION_01  = "KK01";	// T01
	public static final String DTL_PAY_DEDUCTION_02  = "KK02";	// T02
	public static final String DTL_PAY_DEDUCTION_03  = "KK03";	// T03
	public static final String DTL_PAY_DEDUCTION_04  = "KK04";	// T04
	public static final String DTL_PAY_DEDUCTION_05  = "KK05";	// T05
	public static final String DTL_PAY_DEDUCTION_06  = "KK06";	// T06
	public static final String DTL_PAY_DEDUCTION_07  = "KK07";	// T07
	public static final String DTL_PAY_DEDUCTION_08  = "KK08";	// T08
	public static final String DTL_PAY_DEDUCTION_09  = "KK09";	// T09
	public static final String DTL_PAY_DEDUCTION_10  = "KK10";	// T10
	public static final String DTL_PAY_DEDUCTION_11  = "KK11";	// T11
	public static final String DTL_PAY_DEDUCTION_12  = "KK12";	// T12
	public static final String DTL_PAY_DEDUCTION_13  = "KK13";	// T13
	public static final String DTL_PAY_DEDUCTION_14  = "KK14";	// T14
	public static final String DTL_PAY_DEDUCTION_15  = "KK15";	// T15
	public static final String DTL_PAY_DEDUCTION_16  = "KK16";	// T16
	public static final String DTL_PAY_DEDUCTION_17  = "KK17";	// T17
	public static final String DTL_PAY_DEDUCTION_18  = "KK18";	// T18
	public static final String DTL_PAY_DEDUCTION_19  = "KK19";	// T19
	public static final String DTL_PAY_DEDUCTION_20  = "KK20";	// T20
	
	public static final String DTL_BON_ALLOWANCE_01  = "BA001";
	public static final String DTL_BON_ALLOWANCE_02  = "BA002";
	public static final String DTL_BON_ALLOWANCE_03  = "BA003";
	public static final String DTL_BON_ALLOWANCE_04  = "BA004";
	public static final String DTL_BON_ALLOWANCE_05  = "BA005";
	public static final String DTL_BON_ALLOWANCE_06  = "BA006";
	public static final String DTL_BON_ALLOWANCE_07  = "BA007";
	public static final String DTL_BON_ALLOWANCE_08  = "BA008";
	public static final String DTL_BON_ALLOWANCE_09  = "BA009";
	public static final String DTL_BON_ALLOWANCE_10  = "BA010";
	public static final String DTL_BON_ALLOWANCE_11  = "BA011";
	public static final String DTL_BON_ALLOWANCE_12  = "BA012";
	public static final String DTL_BON_ALLOWANCE_13  = "BA013";
	public static final String DTL_BON_ALLOWANCE_14  = "BA014";
	public static final String DTL_BON_ALLOWANCE_15  = "BA015";
	public static final String DTL_BON_ALLOWANCE_16  = "BA016";
	public static final String DTL_BON_ALLOWANCE_17  = "BA017";
	public static final String DTL_BON_ALLOWANCE_18  = "BA018";
	public static final String DTL_BON_ALLOWANCE_19  = "BA019";
	public static final String DTL_BON_ALLOWANCE_20  = "BA020";
	public static final String DTL_BON_DEDUCTION_01  = "BD001";
	public static final String DTL_BON_DEDUCTION_02  = "BD002";
	public static final String DTL_BON_DEDUCTION_03  = "BD003";
	public static final String DTL_BON_DEDUCTION_04  = "BD004";
	public static final String DTL_BON_DEDUCTION_05  = "BD005";
	public static final String DTL_BON_DEDUCTION_06  = "BD006";
	public static final String DTL_BON_DEDUCTION_07  = "BD007";
	public static final String DTL_BON_DEDUCTION_08  = "BD008";
	public static final String DTL_BON_DEDUCTION_09  = "BD009";
	public static final String DTL_BON_DEDUCTION_10  = "BD010";
	public static final String DTL_BON_DEDUCTION_11  = "BD011";
	public static final String DTL_BON_DEDUCTION_12  = "BD012";
	public static final String DTL_BON_DEDUCTION_13  = "BD013";
	public static final String DTL_BON_DEDUCTION_14  = "BD014";
	public static final String DTL_BON_DEDUCTION_15  = "BD015";
	public static final String DTL_BON_DEDUCTION_16  = "BD016";
	public static final String DTL_BON_DEDUCTION_17  = "BD017";
	public static final String DTL_BON_DEDUCTION_18  = "BD018";
	public static final String DTL_BON_DEDUCTION_19  = "BD019";
	public static final String DTL_BON_DEDUCTION_20  = "BD020";
	
	public static final String DTL_UNIT_LATE         = "LATE";
	public static final String DTL_UNIT_OVER         = "OVER";
	public static final String DTL_UNIT_HOLI         = "HOLI";
	
	
	/* lAbv[h */
	public static final String UP_K_CODE              = "K_CODE";             // ЈR[h
	public static final String UP_CALC_DATE           = "CALC_DATE";          // vZN
	public static final String UP_ABILITY2_ALLOWANCE  = "ABILITY2_ALLOWANCE";	// E\蓖2
	
	/* P敪Abv[hR[h */
	public static final String UP_UNIT_KK11           = "UNIT_KK11";
	public static final String UP_UNIT_KK14           = "UNIT_KK14";
	public static final String UP_UNIT_KK15           = "UNIT_KK15";
	public static final String UP_UNIT_KK16           = "UNIT_KK16";
	public static final String UP_UNIT_KK17           = "UNIT_KK17";
	public static final String UP_UNIT_KK18           = "UNIT_KK18";
	public static final String UP_UNIT_KK19           = "UNIT_KK19";
	public static final String UP_UNIT_KK20           = "UNIT_KK20";
	public static final String UP_UNIT_KS03           = "UNIT_KS03";
	public static final String UP_UNIT_KS06           = "UNIT_KS06";
	public static final String UP_UNIT_KS13           = "UNIT_KS13";
	public static final String UP_UNIT_LATE           = "UNIT_LATE";
	public static final String UP_UNIT_OVER           = "UNIT_OVER";
	public static final String UP_UNIT_HOLI           = "UNIT_HOLI";
	/* ZŃAbv[hR[h */
	public static final String UP_PAYMENT_CITY_CODE   = "PAYMENT_CITY_CODE";
	public static final String UP_SUBMIT_CITY_CODE    = "SUBMIT_CITY_CODE" ;
	public static final String UP_JUNE_AMOUNT         = "JUNE_AMOUNT"      ;
	public static final String UP_JULY_AMOUNT         = "JULY_AMOUNT"      ;
	public static final String UP_AUGUST_AMOUNT       = "AUGUST_AMOUNT"    ;
	public static final String UP_SEPTEMBER_AMOUNT    = "SEPTEMBER_AMOUNT" ;
	public static final String UP_OCTOBER_AMOUNT      = "OCTOBER_AMOUNT"   ;
	public static final String UP_NOVEMBER_AMOUNT     = "NOVEMBER_AMOUNT"  ;
	public static final String UP_DECEMBER_AMOUNT     = "DECEMBER_AMOUNT"  ;
	public static final String UP_JANUARY_AMOUNT      = "JANUARY_AMOUNT"   ;
	public static final String UP_FEBRUARY_AMOUNT     = "FEBRUARY_AMOUNT"  ;
	public static final String UP_MARCH_AMOUNT        = "MARCH_AMOUNT"     ;
	public static final String UP_APRIL_AMOUNT        = "APRIL_AMOUNT"     ;
	public static final String UP_MAY_AMOUNT          = "MAY_AMOUNT"       ;
	/* ЉیAbv[hR[h */
	public static final String UP_PENSION_TYPE           = "PENSION_TYPE"      ;
	public static final String UP_PARTTIME_TYPE          = "PARTTIME_TYPE"     ;
	public static final String UP_EMPLOYEE_TYPE          = "EMPLOYEE_TYPE"     ;
	public static final String UP_CALC_INS_TYPE          = "CALC_INS_TYPE"     ;
	public static final String UP_NURSING_INS_TYPE       = "NURSING_INS_TYPE"  ;
	public static final String UP_CALC_UNEMPLOY_TYPE     = "CALC_UNEMPLOY_TYPE";
	public static final String UP_BONUS_HEALTH_TYPE      = "BONUS_HEALTH_TYPE" ;
	public static final String UP_BONUS_PENSION_TYPE     = "BONUS_PENSION_TYPE";
	public static final String UP_HEALTH_NO              = "HEALTH_NO"         ;
	public static final String UP_HEALTH_PAYMENT         = "HEALTH_PAYMENT"    ;
	public static final String UP_HEALTH_GET_DATE        = "HEALTH_GET_DATE"   ;
	public static final String UP_HEALTH_LOST_TYPE       = "HEALTH_LOST_TYPE"  ;
	public static final String UP_HEALTH_LOST_DATE       = "HEALTH_LOST_DATE"  ;
	public static final String UP_PENSION_NO             = "PENSION_NO"        ;
	public static final String UP_PENSION_PAYMENT        = "PENSION_PAYMENT"   ;
	public static final String UP_PENSION_GET_DATE       = "PENSION_GET_DATE"  ;
	public static final String UP_PENSION_LOST_TYPE      = "PENSION_LOST_TYPE" ;
	public static final String UP_PENSION_LOST_DATE      = "PENSION_LOST_DATE" ;
	public static final String UP_FUND_NO                = "FUND_NO"           ;
	public static final String UP_FUND_GET_DATE          = "FUND_GET_DATE"     ;
	public static final String UP_UNEMPLOY_NO            = "UNEMPLOY_NO"       ;
	public static final String UP_UNEMPLOY_GET_DATE      = "UNEMPLOY_GET_DATE" ;
	public static final String UP_UNEMPLOY_LOST_TYPE     = "UNEMPLOY_LOST_TYPE";
	public static final String UP_UNEMPLOY_LOST_DATE     = "UNEMPLOY_LOST_DATE";
	
	/* lAbv[h */
	public static final String UP_PAYMENT_INTERVAL1  = "PAYMENT_INTERVAL1" ;	// xԊu
	public static final String UP_LUMP_MONTHLY_TYPE1 = "LUMP_MONTHLY_TYPE1";	// ꊇ敪
	public static final String UP_PAY_START_MONTH1   = "PAY_START_MONTH1"  ;	// xJn
	public static final String UP_COMMUTE_AMOUNT1    = "COMMUTE_AMOUNT1"   ;	// ʋΎ蓖xz
	public static final String UP_COMMUTE_TAXED1     = "COMMUTE_TAXED1"    ;	// ېŒʋΔ
	public static final String UP_PAYMENT_INTERVAL2  = "PAYMENT_INTERVAL2" ;	// xԊu
	public static final String UP_LUMP_MONTHLY_TYPE2 = "LUMP_MONTHLY_TYPE2";	// ꊇ敪
	public static final String UP_PAY_START_MONTH2   = "PAY_START_MONTH2"  ;	// xJn
	public static final String UP_COMMUTE_DISTANCE2  = "COMMUTE_DISTANCE2" ;	// Г
	public static final String UP_COMMUTE_AMOUNT2    = "COMMUTE_AMOUNT2"   ;	// ʋΎ蓖xz
	public static final String UP_COMMUTE_TAXED2     = "COMMUTE_TAXED2"    ;	// ېŒʋΔ
	public static final String DF_PAYMENT_INTERVAL1  = "1";	// 
	public static final String DF_PAYMENT_INTERVAL2  = "5";	// 
	public static final String DF_LUMP_MONTHLY_TYPE  = "1";	// ꊇ
	public static final String DF_PAY_START_MONTH    = "1970/1/1";	// 1
	
	
	/* ܗ^Abv[hR[h */
	public static final String UP_BONUS_ALLOWANCE_01  = "BA001";
	public static final String UP_BONUS_ALLOWANCE_02  = "BA002";
	public static final String UP_BONUS_ALLOWANCE_03  = "BA003";
	public static final String UP_BONUS_ALLOWANCE_04  = "BA004";
	public static final String UP_BONUS_ALLOWANCE_05  = "BA005";
	public static final String UP_BONUS_ALLOWANCE_06  = "BA006";
	public static final String UP_BONUS_ALLOWANCE_07  = "BA007";
	public static final String UP_BONUS_ALLOWANCE_08  = "BA008";
	public static final String UP_BONUS_ALLOWANCE_09  = "BA009";
	public static final String UP_BONUS_ALLOWANCE_10  = "BA010";
	public static final String UP_BONUS_ALLOWANCE_11  = "BA011";
	public static final String UP_BONUS_ALLOWANCE_12  = "BA012";
	public static final String UP_BONUS_ALLOWANCE_13  = "BA013";
	public static final String UP_BONUS_ALLOWANCE_14  = "BA014";
	public static final String UP_BONUS_ALLOWANCE_15  = "BA015";
	public static final String UP_BONUS_ALLOWANCE_16  = "BA016";
	public static final String UP_BONUS_ALLOWANCE_17  = "BA017";
	public static final String UP_BONUS_ALLOWANCE_18  = "BA018";
	public static final String UP_BONUS_ALLOWANCE_19  = "BA019";
	public static final String UP_BONUS_ALLOWANCE_20  = "BA020";
	public static final String UP_BONUS_DEDUCTION_01  = "BD001";
	public static final String UP_BONUS_DEDUCTION_02  = "BD002";
	public static final String UP_BONUS_DEDUCTION_03  = "BD003";
	public static final String UP_BONUS_DEDUCTION_04  = "BD004";
	public static final String UP_BONUS_DEDUCTION_05  = "BD005";
	public static final String UP_BONUS_DEDUCTION_06  = "BD006";
	public static final String UP_BONUS_DEDUCTION_07  = "BD007";
	public static final String UP_BONUS_DEDUCTION_08  = "BD008";
	public static final String UP_BONUS_DEDUCTION_09  = "BD009";
	public static final String UP_BONUS_DEDUCTION_10  = "BD010";
	public static final String UP_BONUS_DEDUCTION_11  = "BD011";
	public static final String UP_BONUS_DEDUCTION_12  = "BD012";
	public static final String UP_BONUS_DEDUCTION_13  = "BD013";
	public static final String UP_BONUS_DEDUCTION_14  = "BD014";
	public static final String UP_BONUS_DEDUCTION_15  = "BD015";
	public static final String UP_BONUS_DEDUCTION_16  = "BD016";
	public static final String UP_BONUS_DEDUCTION_17  = "BD017";
	public static final String UP_BONUS_DEDUCTION_18  = "BD018";
	public static final String UP_BONUS_DEDUCTION_19  = "BD019";
	public static final String UP_BONUS_DEDUCTION_20  = "BD020";
	
	/* l{Abv[h */
	public static final String UP_STATION_CODE      = "STATION_CODE"     ;	// R[h
	public static final String UP_POSITION_CODE     = "POSITION_CODE"    ;	// EʃR[h
	public static final String UP_GRADE             = "GRADE"            ;	// 
	public static final String UP_NOTCH             = "NOTCH"            ;	// 
	public static final String UP_EMPLOYMENT_TYPE   = "EMPLOYMENT_TYPE"  ;	// ٗp敪
	public static final String UP_RETIRE_MONEY_DATE = "RETIRE_MONEY_DATE";	// ސENZ

	/* vZP */
	public static final int    UNIT_AMOUNT_COUNT = 20;	// vZP

	/* FBf[^ŏR[h */
	public static final int    FB_LOWER_LEN_RECORD = 120;		// FBf[^ŏR[h 
	
	/* VXeǗҌ */
	public static final String AUTH_SYSTEM = "99";
	
	/* L[(p[^)Zp[^ */
	public static final String KEY_SEPARATOR = ",";
	
	/* ȗ */
	public static final String STR_ABBREVIATION = "...";
	
	/*  */
	public static final String STR_ARROW = "";
	
	/* ؕ */
	public static final String STR_TITLE_SEPARATOR = "F";
	public static final String STR_TERM            = "`"; 
	public static final String STR_JP_SEPARATOR    = "A";
	public static final String STR_BLANK           = " ";
	
	/* [`FbN}[Np */
	public static final String STR_CHECK_MARK = "P";
	
	/*  */
	public static final String STR_RATE = "/1000";
	
	/* t֘Al */
	public static final int    TIME_DEFAULT_YEAR  = 1970;
	public static final int    TIME_DEFAULT_MONTH = 0;
	public static final int    TIME_DEFAULT_DAY   = 1;
	public static final String TIME_DEF_DAY_STR   = "/01";
	public static final int    TIME_ADJ_PAY_MONTH =   12;
	public static final int    TIME_SHOWA_LONG    =   63;
	public static final int    TIME_YEAR_FORMER   =   10;	// v_EߋN
	public static final int    TIME_YEAR_FURTHER  =    1;	// v_EN
	public static final int    TIME_YEAR_MIN      = 1868;	// Nŏl(a̕\E)
	public static final int    TIME_YEAR_MAX      = 2050;	// Nől(a̕\E)
	
	/* lN */
	public static final int    AGE_ADLUT = 20;
	
	/* ScƏǗp */
	public static final int POSITION_CODE_TRAINER = 30;

	/* ܗ^o^l */
	public static final int UPPER_BONUS_REGIST = 3;

	/* o͍ڃ{^̎擾p萔 */
	public static final String  OUT_BUTTON_NAME = "BTN_NM";
	/* o͍ڔԍ擾p萔 */
	public static final String    OUT_ITEM_BUTTON  = "OUTPUT";

	
	// z敪(x@)
	public static final String AMOUNT_TYPE_ALL    = "1";	// Sz
	public static final String AMOUNT_TYPE_AMOUNT = "2";	// z
	public static final String AMOUNT_TYPE_RATIO  = "3";	// 藦
	public static final String AMOUNT_TYPE_REST   = "4";	// cz
	public static final String AMOUNT_TYPE_ALL_NAME    = "Sz";
	public static final String AMOUNT_TYPE_AMOUNT_NAME = "z"; 
	public static final String AMOUNT_TYPE_RATIO_NAME  = "藦";
	public static final String AMOUNT_TYPE_REST_NAME   = "cz";
	public static final String[][] getAmountTypeArray() {
		return new String[][] {
			{AMOUNT_TYPE_ALL   , AMOUNT_TYPE_ALL_NAME   },
			{AMOUNT_TYPE_AMOUNT, AMOUNT_TYPE_AMOUNT_NAME},
			{AMOUNT_TYPE_RATIO , AMOUNT_TYPE_RATIO_NAME }
		};
	}
	public static final String[][] getAmountTypeArrayForRest() {
		return new String[][] {
			{AMOUNT_TYPE_REST  , AMOUNT_TYPE_REST_NAME  }
		};
	}
	public static final String[][] getAmountTypeArrayAll() {
		return new String[][] {
			{AMOUNT_TYPE_ALL   , AMOUNT_TYPE_ALL_NAME   },
			{AMOUNT_TYPE_AMOUNT, AMOUNT_TYPE_AMOUNT_NAME},
			{AMOUNT_TYPE_RATIO , AMOUNT_TYPE_RATIO_NAME },
			{AMOUNT_TYPE_REST  , AMOUNT_TYPE_REST_NAME  }
		};
	}

	// vZXe[^X
	public static final String CALC_STATUS_NO   = "0";
	public static final String CALC_STATUS_CRE  = "1";
	public static final String CALC_STATUS_TAX  = "2";
	public static final String CALC_STATUS_EDIT = "3";
	public static final String CALC_STATUS_FIX  = "4";
	public static final String CALC_STATUS_FB  = "5";
	public static final String CALC_STATUS_NO_NAME   = "f[^쐬";
	public static final String CALC_STATUS_CRE_NAME  = "f[^쐬";
	public static final String CALC_STATUS_TAX_NAME  = "@TvZ";
	public static final String CALC_STATUS_EDIT_NAME = "@TC";
	public static final String CALC_STATUS_FIX_NAME  = "m菈ς";
	public static final String CALC_STATUS_FB_NAME  = "FBf[^쐬ς";
	public static final String[][] getCalcStatusArray() {
		return new String[][] {
			{CALC_STATUS_NO  , CALC_STATUS_NO_NAME  },
			{CALC_STATUS_CRE , CALC_STATUS_CRE_NAME },
			{CALC_STATUS_TAX , CALC_STATUS_TAX_NAME },
			{CALC_STATUS_EDIT, CALC_STATUS_EDIT_NAME},
			{CALC_STATUS_FIX , CALC_STATUS_FIX_NAME },
			{CALC_STATUS_FB  , CALC_STATUS_FB_NAME }
		};
	}
	
	// Z茋 
	public static final String CALC_RESULT_EXC = "0";
	public static final String CALC_RESULT_CAL = "1";
	public static final String CALC_RESULT_CHA = "2";
	public static final String CALC_RESULT_EXC_NAME  = "O";
	public static final String CALC_RESULT_CAL_NAME  = "Z";
	public static final String CALC_RESULT_CHA_NAME  = "";
	public static final String[][] getCalcResultArray() {
		return new String[][] {
			{CALC_RESULT_EXC  , CALC_RESULT_EXC_NAME},
			{CALC_RESULT_CAL , CALC_RESULT_CAL_NAME },
			{CALC_RESULT_CHA , CALC_RESULT_CHA_NAME }
		};
	}
	
	// NXe[^X
	public static final String ADJU_STATUS_NON = "0";
	public static final String ADJU_STATUS_CRE = "1";
	public static final String ADJU_STATUS_OOT = "2";
	public static final String ADJU_STATUS_FIX = "3";
	public static final String ADJU_STATUS_NON_NAME = "f[^쐬";
	public static final String ADJU_STATUS_CRE_NAME = "f[^쐬";
	public static final String ADJU_STATUS_OOT_NAME = "N(ΏۊO)";
	public static final String ADJU_STATUS_FIX_NAME = "NvZ";
	public static final String[][] getAdjuStatusArray() {
		return new String[][] {
			{ADJU_STATUS_NON, ADJU_STATUS_NON_NAME},
			{ADJU_STATUS_CRE, ADJU_STATUS_CRE_NAME},
			{ADJU_STATUS_OOT, ADJU_STATUS_OOT_NAME},
			{ADJU_STATUS_FIX, ADJU_STATUS_FIX_NAME}
		};
	}
	
	// FBf[^o͓e
	public static final String FB_OUTPUT_DETAIL_PAYMENT    = "0";
	public static final String FB_OUTPUT_DETAIL_BONUS      = "1";
	public static final String FB_OUTPUT_DETAIL_RES        = "2";
	public static final String FB_OUTPUT_DETAIL_PAY_NAME   = "^";
	public static final String FB_OUTPUT_DETAIL_BONUS_NAME = "ܗ^";
	public static final String FB_OUTPUT_DETAIL_RES_NAME   = "Z";
	public static final String[][] getOutputDetailArray() {
		return new String[][] {
			{FB_OUTPUT_DETAIL_PAYMENT, FB_OUTPUT_DETAIL_PAY_NAME  },
			{FB_OUTPUT_DETAIL_BONUS  , FB_OUTPUT_DETAIL_BONUS_NAME},
			{FB_OUTPUT_DETAIL_RES    , FB_OUTPUT_DETAIL_RES_NAME  }
		};
	}
	
	// FBf[^R[h敪
	public static final String FB_CODE_TYPE_JIS         = "0";
	public static final String FB_CODE_TYPE_EBCDIC      = "1";
	public static final String FB_CODE_TYPE_JIS_NAME    = "0";
	public static final String FB_CODE_TYPE_EBCDIC_NAME = "1";
	public static final String[][] getCodeTypeArray() {
		return new String[][] {
			{FB_CODE_TYPE_JIS   , FB_CODE_TYPE_JIS_NAME   },
			{FB_CODE_TYPE_EBCDIC, FB_CODE_TYPE_EBCDIC_NAME}
		};
	}
	
	// FBf[^R[h敪
	public static final String FB_RECORD_TYPE_NONE  = "0";
	public static final String FB_RECORD_TYPE_GIVE = "1";
	public static final String FB_RECORD_TYPE_NON_NAME  = "tȂ";
	public static final String FB_RECORD_TYPE_GIVE_NAME = "t";
	public static final String[][] getRecordTypeArray() {
		return new String[][] {
			{FB_RECORD_TYPE_NONE, FB_RECORD_TYPE_NON_NAME },
			{FB_RECORD_TYPE_GIVE, FB_RECORD_TYPE_GIVE_NAME}
		};
	}
	
	// FBf[^GhR[h
	public static final String FB_END_RECORD_NONE  = "0";
	public static final String FB_END_RECORD_GIVE = "1";
	public static final String FB_END_RECORD_NON_NAME  = "tȂ";
	public static final String FB_END_RECORD_GIVE_NAME = "t";
	public static final String[][] getEndRecordArray() {
		return new String[][] {
			{FB_END_RECORD_NONE, FB_END_RECORD_NON_NAME },
			{FB_END_RECORD_GIVE, FB_END_RECORD_GIVE_NAME}
		};
	}
	

	// ٓLz
	public static final String CITY_CHANGES_NONE      = "0";
	public static final String CITY_CHANGES           = "1";
	public static final String CITY_CHANGES_NONE_NAME = "ٓȂ";
	public static final String CITY_CHANGES_NAME      = "ٓ";
	public static final String[][] getCityChangesArray() {
		return new String[][] {
			{CITY_CHANGES_NONE, CITY_CHANGES_NONE_NAME },
			{CITY_CHANGES     , CITY_CHANGES_NAME      }
		};
	}
	
	// o͓e{^̑Iz
	public static final String SAVE_OUTPUT_01      = "1";
	public static final String SAVE_OUTPUT_02      = "2";
	public static final String SAVE_OUTPUT_03      = "3";
	public static final String SAVE_OUTPUT_04      = "4";
	public static final String SAVE_OUTPUT_NAME_01 = "1";
	public static final String SAVE_OUTPUT_NAME_02 = "2";
	public static final String SAVE_OUTPUT_NAME_03 = "3";
	public static final String SAVE_OUTPUT_NAME_04 = "4";

	public static final String[][] getOutSaveNameArray() {
		return new String[][] {
				{SAVE_OUTPUT_01, SAVE_OUTPUT_NAME_01 },
				{SAVE_OUTPUT_02, SAVE_OUTPUT_NAME_02 },
				{SAVE_OUTPUT_03, SAVE_OUTPUT_NAME_03 },
				{SAVE_OUTPUT_04, SAVE_OUTPUT_NAME_04 }
		};
	}
	
	// C}X^ʃtO
	public static final String[][] getEffortFlagArray() {
		return new String[][] {
				{String.valueOf(EFFORT_FLAG_OFF), "ʖ" },
				{String.valueOf(EFFORT_FLAG_ON ), "ʗL" }
		};
	}
	
	/* [o͗p */
	public static final String NAM_CASH_KIND_PAIROLL	 = "ꗗ";
	public static final String NAM_BANK_PARSON_PAIROLL = "sU(l)";
	public static final String NAM_BANK_COMPANY_PAIROLL = "sU(Ћs)";
	public static final String NMA_COMMON_COLLECT = "z";
	public static final String NMA_SUBTOTAL           = "v";
	public static final String NMA_SHARE              = "";
	public static final String NMA_YOKIN              = "a";
	/* o̓t@C */
	public static final String FILE_CASH_KIND_LIST    = "cashKindList.xls";
	public static final String FILE_CASH_KIND_LIST_ODS    = "cashKindList.ods";
	public static final String FILE_BANK_FRKOM_LIST  = "bankFrkomList.xls";
	public static final String FILE_COMPANY_BANK_FRKOM_LIST  = "companyBankFrkomList.xls";
	/* ev[gt@C */
	public static final String TEMPLATE_CASH_KIND_LIST  = "/template/cashKindList.xls";
	public static final String TEMPLATE_CASH_KIND_LIST_ODS  = "/template/cashKindList.ods";
	public static final String TEMPLATE_BANK_FRKOM_LIST  = "/template/bankFrkomList.xls";
	public static final String TEMPLATE_COMPANY_BANK_FRKOM_LIST  = "/template/companyBankFrkomList.xls";

	
	
}
